// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Configuration properties for apps environment custom domain.
/// </summary>
public partial class ContainerAppCustomDomainConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Id used to verify domain name ownership.
    /// </summary>
    public BicepValue<string> CustomDomainVerificationId 
    {
        get { Initialize(); return _customDomainVerificationId!; }
    }
    private BicepValue<string>? _customDomainVerificationId;

    /// <summary>
    /// Dns suffix for the environment domain.
    /// </summary>
    public BicepValue<string> DnsSuffix 
    {
        get { Initialize(); return _dnsSuffix!; }
        set { Initialize(); _dnsSuffix!.Assign(value); }
    }
    private BicepValue<string>? _dnsSuffix;

    /// <summary>
    /// PFX or PEM blob.
    /// </summary>
    public BicepValue<BinaryData> CertificateValue 
    {
        get { Initialize(); return _certificateValue!; }
        set { Initialize(); _certificateValue!.Assign(value); }
    }
    private BicepValue<BinaryData>? _certificateValue;

    /// <summary>
    /// Certificate password.
    /// </summary>
    public BicepValue<string> CertificatePassword 
    {
        get { Initialize(); return _certificatePassword!; }
        set { Initialize(); _certificatePassword!.Assign(value); }
    }
    private BicepValue<string>? _certificatePassword;

    /// <summary>
    /// Certificate expiration date.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// Certificate thumbprint.
    /// </summary>
    public BicepValue<string> Thumbprint 
    {
        get { Initialize(); return _thumbprint!; }
    }
    private BicepValue<string>? _thumbprint;

    /// <summary>
    /// Subject name of the certificate.
    /// </summary>
    public BicepValue<string> SubjectName 
    {
        get { Initialize(); return _subjectName!; }
    }
    private BicepValue<string>? _subjectName;

    /// <summary>
    /// Creates a new ContainerAppCustomDomainConfiguration.
    /// </summary>
    public ContainerAppCustomDomainConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppCustomDomainConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _customDomainVerificationId = DefineProperty<string>("CustomDomainVerificationId", ["customDomainVerificationId"], isOutput: true);
        _dnsSuffix = DefineProperty<string>("DnsSuffix", ["dnsSuffix"]);
        _certificateValue = DefineProperty<BinaryData>("CertificateValue", ["certificateValue"]);
        _certificatePassword = DefineProperty<string>("CertificatePassword", ["certificatePassword"]);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["expirationDate"], isOutput: true);
        _thumbprint = DefineProperty<string>("Thumbprint", ["thumbprint"], isOutput: true);
        _subjectName = DefineProperty<string>("SubjectName", ["subjectName"], isOutput: true);
    }
}
