// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App credentials.
/// </summary>
public partial class ContainerAppCredentials : ProvisionableConstruct
{
    /// <summary>
    /// Client Id.
    /// </summary>
    public BicepValue<string> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<string>? _clientId;

    /// <summary>
    /// Client Secret.
    /// </summary>
    public BicepValue<string> ClientSecret 
    {
        get { Initialize(); return _clientSecret!; }
        set { Initialize(); _clientSecret!.Assign(value); }
    }
    private BicepValue<string>? _clientSecret;

    /// <summary>
    /// Tenant Id.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Kind of auth github does for deploying the template.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Subscription Id.
    /// </summary>
    public BicepValue<string> SubscriptionId 
    {
        get { Initialize(); return _subscriptionId!; }
        set { Initialize(); _subscriptionId!.Assign(value); }
    }
    private BicepValue<string>? _subscriptionId;

    /// <summary>
    /// Creates a new ContainerAppCredentials.
    /// </summary>
    public ContainerAppCredentials()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppCredentials.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientId = DefineProperty<string>("ClientId", ["clientId"]);
        _clientSecret = DefineProperty<string>("ClientSecret", ["clientSecret"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _subscriptionId = DefineProperty<string>("SubscriptionId", ["subscriptionId"]);
    }
}
