// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Cross-Origin-Resource-Sharing policy.
/// </summary>
public partial class ContainerAppCorsPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Specifies the content for the access-control-allow-origins header.
    /// </summary>
    public BicepList<string> AllowedOrigins 
    {
        get { Initialize(); return _allowedOrigins!; }
        set { Initialize(); _allowedOrigins!.Assign(value); }
    }
    private BicepList<string>? _allowedOrigins;

    /// <summary>
    /// Specifies the content for the access-control-allow-methods header.
    /// </summary>
    public BicepList<string> AllowedMethods 
    {
        get { Initialize(); return _allowedMethods!; }
        set { Initialize(); _allowedMethods!.Assign(value); }
    }
    private BicepList<string>? _allowedMethods;

    /// <summary>
    /// Specifies the content for the access-control-allow-headers header.
    /// </summary>
    public BicepList<string> AllowedHeaders 
    {
        get { Initialize(); return _allowedHeaders!; }
        set { Initialize(); _allowedHeaders!.Assign(value); }
    }
    private BicepList<string>? _allowedHeaders;

    /// <summary>
    /// Specifies the content for the access-control-expose-headers header.
    /// </summary>
    public BicepList<string> ExposeHeaders 
    {
        get { Initialize(); return _exposeHeaders!; }
        set { Initialize(); _exposeHeaders!.Assign(value); }
    }
    private BicepList<string>? _exposeHeaders;

    /// <summary>
    /// Specifies the content for the access-control-max-age header.
    /// </summary>
    public BicepValue<int> MaxAge 
    {
        get { Initialize(); return _maxAge!; }
        set { Initialize(); _maxAge!.Assign(value); }
    }
    private BicepValue<int>? _maxAge;

    /// <summary>
    /// Specifies whether the resource allows credentials.
    /// </summary>
    public BicepValue<bool> AllowCredentials 
    {
        get { Initialize(); return _allowCredentials!; }
        set { Initialize(); _allowCredentials!.Assign(value); }
    }
    private BicepValue<bool>? _allowCredentials;

    /// <summary>
    /// Creates a new ContainerAppCorsPolicy.
    /// </summary>
    public ContainerAppCorsPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppCorsPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowedOrigins = DefineListProperty<string>("AllowedOrigins", ["allowedOrigins"]);
        _allowedMethods = DefineListProperty<string>("AllowedMethods", ["allowedMethods"]);
        _allowedHeaders = DefineListProperty<string>("AllowedHeaders", ["allowedHeaders"]);
        _exposeHeaders = DefineListProperty<string>("ExposeHeaders", ["exposeHeaders"]);
        _maxAge = DefineProperty<int>("MaxAge", ["maxAge"]);
        _allowCredentials = DefineProperty<bool>("AllowCredentials", ["allowCredentials"]);
    }
}
