// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Non versioned Container App configuration properties that define the
/// mutable settings of a Container app.
/// </summary>
public partial class ContainerAppConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Collection of secrets used by a Container app.
    /// </summary>
    public BicepList<ContainerAppWritableSecret> Secrets 
    {
        get { Initialize(); return _secrets!; }
        set { Initialize(); _secrets!.Assign(value); }
    }
    private BicepList<ContainerAppWritableSecret>? _secrets;

    /// <summary>
    /// ActiveRevisionsMode controls how active revisions are handled for the
    /// Container app:             &lt;list&gt;&lt;item&gt;Multiple: multiple
    /// revisions can be active.&lt;/item&gt;&lt;item&gt;Single: Only one
    /// revision can be active at a time. Revision weights can not be used in
    /// this mode. If no value if provided, this is the
    /// default.&lt;/item&gt;&lt;/list&gt;
    /// </summary>
    public BicepValue<ContainerAppActiveRevisionsMode> ActiveRevisionsMode 
    {
        get { Initialize(); return _activeRevisionsMode!; }
        set { Initialize(); _activeRevisionsMode!.Assign(value); }
    }
    private BicepValue<ContainerAppActiveRevisionsMode>? _activeRevisionsMode;

    /// <summary>
    /// Ingress configurations.
    /// </summary>
    public ContainerAppIngressConfiguration Ingress 
    {
        get { Initialize(); return _ingress!; }
        set { Initialize(); AssignOrReplace(ref _ingress, value); }
    }
    private ContainerAppIngressConfiguration? _ingress;

    /// <summary>
    /// Collection of private container registry credentials for containers
    /// used by the Container app.
    /// </summary>
    public BicepList<ContainerAppRegistryCredentials> Registries 
    {
        get { Initialize(); return _registries!; }
        set { Initialize(); _registries!.Assign(value); }
    }
    private BicepList<ContainerAppRegistryCredentials>? _registries;

    /// <summary>
    /// Dapr configuration for the Container App.
    /// </summary>
    public ContainerAppDaprConfiguration Dapr 
    {
        get { Initialize(); return _dapr!; }
        set { Initialize(); AssignOrReplace(ref _dapr, value); }
    }
    private ContainerAppDaprConfiguration? _dapr;

    /// <summary>
    /// Optional. Max inactive revisions a Container App can have.
    /// </summary>
    public BicepValue<int> MaxInactiveRevisions 
    {
        get { Initialize(); return _maxInactiveRevisions!; }
        set { Initialize(); _maxInactiveRevisions!.Assign(value); }
    }
    private BicepValue<int>? _maxInactiveRevisions;

    /// <summary>
    /// Dev ContainerApp service type.
    /// </summary>
    public BicepValue<string> ServiceType 
    {
        get { Initialize(); return _serviceType!; }
        set { Initialize(); _serviceType!.Assign(value); }
    }
    private BicepValue<string>? _serviceType;

    /// <summary>
    /// Creates a new ContainerAppConfiguration.
    /// </summary>
    public ContainerAppConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _secrets = DefineListProperty<ContainerAppWritableSecret>("Secrets", ["secrets"]);
        _activeRevisionsMode = DefineProperty<ContainerAppActiveRevisionsMode>("ActiveRevisionsMode", ["activeRevisionsMode"]);
        _ingress = DefineModelProperty<ContainerAppIngressConfiguration>("Ingress", ["ingress"]);
        _registries = DefineListProperty<ContainerAppRegistryCredentials>("Registries", ["registries"]);
        _dapr = DefineModelProperty<ContainerAppDaprConfiguration>("Dapr", ["dapr"]);
        _maxInactiveRevisions = DefineProperty<int>("MaxInactiveRevisions", ["maxInactiveRevisions"]);
        _serviceType = DefineProperty<string>("ServiceType", ["service", "type"]);
    }
}
