// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Azure Active Directory token validation
/// flow.
/// </summary>
public partial class ContainerAppAzureActiveDirectoryValidationConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// The configuration settings of the checks that should be made while
    /// validating the JWT Claims.
    /// </summary>
    public ContainerAppJwtClaimChecks JwtClaimChecks 
    {
        get { Initialize(); return _jwtClaimChecks!; }
        set { Initialize(); AssignOrReplace(ref _jwtClaimChecks, value); }
    }
    private ContainerAppJwtClaimChecks? _jwtClaimChecks;

    /// <summary>
    /// The list of audiences that can make successful
    /// authentication/authorization requests.
    /// </summary>
    public BicepList<string> AllowedAudiences 
    {
        get { Initialize(); return _allowedAudiences!; }
        set { Initialize(); _allowedAudiences!.Assign(value); }
    }
    private BicepList<string>? _allowedAudiences;

    /// <summary>
    /// The configuration settings of the default authorization policy.
    /// </summary>
    public ContainerAppDefaultAuthorizationPolicy DefaultAuthorizationPolicy 
    {
        get { Initialize(); return _defaultAuthorizationPolicy!; }
        set { Initialize(); AssignOrReplace(ref _defaultAuthorizationPolicy, value); }
    }
    private ContainerAppDefaultAuthorizationPolicy? _defaultAuthorizationPolicy;

    /// <summary>
    /// Creates a new ContainerAppAzureActiveDirectoryValidationConfiguration.
    /// </summary>
    public ContainerAppAzureActiveDirectoryValidationConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppAzureActiveDirectoryValidationConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _jwtClaimChecks = DefineModelProperty<ContainerAppJwtClaimChecks>("JwtClaimChecks", ["jwtClaimChecks"]);
        _allowedAudiences = DefineListProperty<string>("AllowedAudiences", ["allowedAudiences"]);
        _defaultAuthorizationPolicy = DefineModelProperty<ContainerAppDefaultAuthorizationPolicy>("DefaultAuthorizationPolicy", ["defaultAuthorizationPolicy"]);
    }
}
