// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Azure Active Directory login flow.
/// </summary>
public partial class ContainerAppAzureActiveDirectoryLoginConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Login parameters to send to the OpenID Connect authorization endpoint
    /// when             a user logs in. Each parameter must be in the form
    /// &quot;key=value&quot;.
    /// </summary>
    public BicepList<string> LoginParameters 
    {
        get { Initialize(); return _loginParameters!; }
        set { Initialize(); _loginParameters!.Assign(value); }
    }
    private BicepList<string>? _loginParameters;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if the www-authenticate provider should
    /// be omitted from the request; otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsWwwAuthenticationDisabled 
    {
        get { Initialize(); return _isWwwAuthenticationDisabled!; }
        set { Initialize(); _isWwwAuthenticationDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isWwwAuthenticationDisabled;

    /// <summary>
    /// Creates a new ContainerAppAzureActiveDirectoryLoginConfiguration.
    /// </summary>
    public ContainerAppAzureActiveDirectoryLoginConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppAzureActiveDirectoryLoginConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _loginParameters = DefineListProperty<string>("LoginParameters", ["loginParameters"]);
        _isWwwAuthenticationDisabled = DefineProperty<bool>("IsWwwAuthenticationDisabled", ["disableWWWAuthenticate"]);
    }
}
