// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Azure Active directory provider.
/// </summary>
public partial class ContainerAppAzureActiveDirectoryConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;false&lt;/code&gt; if the Azure Active Directory provider
    /// should not be enabled despite the set registration; otherwise,
    /// &lt;code&gt;true&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The configuration settings of the Azure Active Directory app
    /// registration.
    /// </summary>
    public ContainerAppAzureActiveDirectoryRegistrationConfiguration Registration 
    {
        get { Initialize(); return _registration!; }
        set { Initialize(); AssignOrReplace(ref _registration, value); }
    }
    private ContainerAppAzureActiveDirectoryRegistrationConfiguration? _registration;

    /// <summary>
    /// The configuration settings of the Azure Active Directory login flow.
    /// </summary>
    public ContainerAppAzureActiveDirectoryLoginConfiguration Login 
    {
        get { Initialize(); return _login!; }
        set { Initialize(); AssignOrReplace(ref _login, value); }
    }
    private ContainerAppAzureActiveDirectoryLoginConfiguration? _login;

    /// <summary>
    /// The configuration settings of the Azure Active Directory token
    /// validation flow.
    /// </summary>
    public ContainerAppAzureActiveDirectoryValidationConfiguration Validation 
    {
        get { Initialize(); return _validation!; }
        set { Initialize(); AssignOrReplace(ref _validation, value); }
    }
    private ContainerAppAzureActiveDirectoryValidationConfiguration? _validation;

    /// <summary>
    /// Gets a value indicating whether the Azure AD configuration was
    /// auto-provisioned using 1st party tooling.             This is an
    /// internal flag primarily intended to support the Azure Management
    /// Portal. Users should not             read or write to this property.
    /// </summary>
    public BicepValue<bool> IsAutoProvisioned 
    {
        get { Initialize(); return _isAutoProvisioned!; }
        set { Initialize(); _isAutoProvisioned!.Assign(value); }
    }
    private BicepValue<bool>? _isAutoProvisioned;

    /// <summary>
    /// Creates a new ContainerAppAzureActiveDirectoryConfiguration.
    /// </summary>
    public ContainerAppAzureActiveDirectoryConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppAzureActiveDirectoryConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _registration = DefineModelProperty<ContainerAppAzureActiveDirectoryRegistrationConfiguration>("Registration", ["registration"]);
        _login = DefineModelProperty<ContainerAppAzureActiveDirectoryLoginConfiguration>("Login", ["login"]);
        _validation = DefineModelProperty<ContainerAppAzureActiveDirectoryValidationConfiguration>("Validation", ["validation"]);
        _isAutoProvisioned = DefineProperty<bool>("IsAutoProvisioned", ["isAutoProvisioned"]);
    }
}
