// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the platform of ContainerApp Service
/// Authentication/Authorization.
/// </summary>
public partial class ContainerAppAuthPlatform : ProvisionableConstruct
{
    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if the Authentication / Authorization
    /// feature is enabled for the current app; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// The RuntimeVersion of the Authentication / Authorization feature in use
    /// for the current app.             The setting in this value can control
    /// the behavior of certain features in the Authentication / Authorization
    /// module.
    /// </summary>
    public BicepValue<string> RuntimeVersion 
    {
        get { Initialize(); return _runtimeVersion!; }
        set { Initialize(); _runtimeVersion!.Assign(value); }
    }
    private BicepValue<string>? _runtimeVersion;

    /// <summary>
    /// Creates a new ContainerAppAuthPlatform.
    /// </summary>
    public ContainerAppAuthPlatform()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppAuthPlatform.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _runtimeVersion = DefineProperty<string>("RuntimeVersion", ["runtimeVersion"]);
    }
}
