// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the registration for the Apple provider.
/// </summary>
public partial class ContainerAppAppleRegistrationConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// The Client ID of the app used for login.
    /// </summary>
    public BicepValue<string> ClientId 
    {
        get { Initialize(); return _clientId!; }
        set { Initialize(); _clientId!.Assign(value); }
    }
    private BicepValue<string>? _clientId;

    /// <summary>
    /// The app setting name that contains the client secret.
    /// </summary>
    public BicepValue<string> ClientSecretSettingName 
    {
        get { Initialize(); return _clientSecretSettingName!; }
        set { Initialize(); _clientSecretSettingName!.Assign(value); }
    }
    private BicepValue<string>? _clientSecretSettingName;

    /// <summary>
    /// Creates a new ContainerAppAppleRegistrationConfiguration.
    /// </summary>
    public ContainerAppAppleRegistrationConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppAppleRegistrationConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientId = DefineProperty<string>("ClientId", ["clientId"]);
        _clientSecretSettingName = DefineProperty<string>("ClientSecretSettingName", ["clientSecretSettingName"]);
    }
}
