// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// The configuration settings of the Azure Active Directory allowed principals.
/// </summary>
public partial class ContainerAppAllowedPrincipals : ProvisionableConstruct
{
    /// <summary>
    /// The list of the allowed groups.
    /// </summary>
    public BicepList<string> Groups 
    {
        get { Initialize(); return _groups!; }
        set { Initialize(); _groups!.Assign(value); }
    }
    private BicepList<string>? _groups;

    /// <summary>
    /// The list of the allowed identities.
    /// </summary>
    public BicepList<string> Identities 
    {
        get { Initialize(); return _identities!; }
        set { Initialize(); _identities!.Assign(value); }
    }
    private BicepList<string>? _identities;

    /// <summary>
    /// Creates a new ContainerAppAllowedPrincipals.
    /// </summary>
    public ContainerAppAllowedPrincipals()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppAllowedPrincipals.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _groups = DefineListProperty<string>("Groups", ["groups"]);
        _identities = DefineListProperty<string>("Identities", ["identities"]);
    }
}
