// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Container App container resource requirements.
/// </summary>
public partial class AppContainerResources : ProvisionableConstruct
{
    /// <summary>
    /// Required CPU in cores, e.g. 0.5.
    /// </summary>
    public BicepValue<double> Cpu 
    {
        get { Initialize(); return _cpu!; }
        set { Initialize(); _cpu!.Assign(value); }
    }
    private BicepValue<double>? _cpu;

    /// <summary>
    /// Required memory, e.g. &quot;250Mb&quot;.
    /// </summary>
    public BicepValue<string> Memory 
    {
        get { Initialize(); return _memory!; }
        set { Initialize(); _memory!.Assign(value); }
    }
    private BicepValue<string>? _memory;

    /// <summary>
    /// Ephemeral Storage, e.g. &quot;1Gi&quot;.
    /// </summary>
    public BicepValue<string> EphemeralStorage 
    {
        get { Initialize(); return _ephemeralStorage!; }
    }
    private BicepValue<string>? _ephemeralStorage;

    /// <summary>
    /// Creates a new AppContainerResources.
    /// </summary>
    public AppContainerResources()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppContainerResources.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _cpu = DefineProperty<double>("Cpu", ["cpu"]);
        _memory = DefineProperty<string>("Memory", ["memory"]);
        _ephemeralStorage = DefineProperty<string>("EphemeralStorage", ["ephemeralStorage"], isOutput: true);
    }
}
