// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// ContainerAppJob.
/// </summary>
public partial class ContainerAppJob : ProvisionableResource
{
    /// <summary>
    /// Job Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Container Apps Job configuration properties.
    /// </summary>
    public ContainerAppJobConfiguration Configuration 
    {
        get { Initialize(); return _configuration!; }
        set { Initialize(); AssignOrReplace(ref _configuration, value); }
    }
    private ContainerAppJobConfiguration? _configuration;

    /// <summary>
    /// Resource ID of environment.
    /// </summary>
    public BicepValue<string> EnvironmentId 
    {
        get { Initialize(); return _environmentId!; }
        set { Initialize(); _environmentId!.Assign(value); }
    }
    private BicepValue<string>? _environmentId;

    /// <summary>
    /// Managed identities needed by a container app job to interact with other
    /// Azure services to not maintain any secrets or credentials in code.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Container Apps job definition.
    /// </summary>
    public ContainerAppJobTemplate Template 
    {
        get { Initialize(); return _template!; }
        set { Initialize(); AssignOrReplace(ref _template, value); }
    }
    private ContainerAppJobTemplate? _template;

    /// <summary>
    /// Workload profile name to pin for container apps job execution.
    /// </summary>
    public BicepValue<string> WorkloadProfileName 
    {
        get { Initialize(); return _workloadProfileName!; }
        set { Initialize(); _workloadProfileName!.Assign(value); }
    }
    private BicepValue<string>? _workloadProfileName;

    /// <summary>
    /// The endpoint of the eventstream of the container apps job.
    /// </summary>
    public BicepValue<string> EventStreamEndpoint 
    {
        get { Initialize(); return _eventStreamEndpoint!; }
    }
    private BicepValue<string>? _eventStreamEndpoint;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Outbound IP Addresses of a container apps job.
    /// </summary>
    public BicepList<string> OutboundIPAddresses 
    {
        get { Initialize(); return _outboundIPAddresses!; }
    }
    private BicepList<string>? _outboundIPAddresses;

    /// <summary>
    /// Provisioning state of the Container Apps Job.
    /// </summary>
    public BicepValue<ContainerAppJobProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerAppJobProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ContainerAppJob.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerAppJob resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppJob.</param>
    public ContainerAppJob(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.App/jobs", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppJob.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _configuration = DefineModelProperty<ContainerAppJobConfiguration>("Configuration", ["properties", "configuration"]);
        _environmentId = DefineProperty<string>("EnvironmentId", ["properties", "environmentId"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _template = DefineModelProperty<ContainerAppJobTemplate>("Template", ["properties", "template"]);
        _workloadProfileName = DefineProperty<string>("WorkloadProfileName", ["properties", "workloadProfileName"]);
        _eventStreamEndpoint = DefineProperty<string>("EventStreamEndpoint", ["properties", "eventStreamEndpoint"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _outboundIPAddresses = DefineListProperty<string>("OutboundIPAddresses", ["properties", "outboundIpAddresses"], isOutput: true);
        _provisioningState = DefineProperty<ContainerAppJobProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ContainerAppJob resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerAppJob.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerAppJob resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppJob.</param>
    /// <returns>The existing ContainerAppJob resource.</returns>
    public static ContainerAppJob FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
