// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// ContainerAppConnectedEnvironmentDaprComponent.
/// </summary>
public partial class ContainerAppConnectedEnvironmentDaprComponent : ProvisionableResource
{
    /// <summary>
    /// Name of the Dapr Component.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Component type.
    /// </summary>
    public BicepValue<string> ComponentType 
    {
        get { Initialize(); return _componentType!; }
        set { Initialize(); _componentType!.Assign(value); }
    }
    private BicepValue<string>? _componentType;

    /// <summary>
    /// Boolean describing if the component errors are ignores.
    /// </summary>
    public BicepValue<bool> IgnoreErrors 
    {
        get { Initialize(); return _ignoreErrors!; }
        set { Initialize(); _ignoreErrors!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreErrors;

    /// <summary>
    /// Initialization timeout.
    /// </summary>
    public BicepValue<string> InitTimeout 
    {
        get { Initialize(); return _initTimeout!; }
        set { Initialize(); _initTimeout!.Assign(value); }
    }
    private BicepValue<string>? _initTimeout;

    /// <summary>
    /// Component metadata.
    /// </summary>
    public BicepList<ContainerAppDaprMetadata> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepList<ContainerAppDaprMetadata>? _metadata;

    /// <summary>
    /// Names of container apps that can use this Dapr component.
    /// </summary>
    public BicepList<string> Scopes 
    {
        get { Initialize(); return _scopes!; }
        set { Initialize(); _scopes!.Assign(value); }
    }
    private BicepList<string>? _scopes;

    /// <summary>
    /// Collection of secrets used by a Dapr component.
    /// </summary>
    public BicepList<ContainerAppWritableSecret> Secrets 
    {
        get { Initialize(); return _secrets!; }
        set { Initialize(); _secrets!.Assign(value); }
    }
    private BicepList<ContainerAppWritableSecret>? _secrets;

    /// <summary>
    /// Name of a Dapr component to retrieve component secrets from.
    /// </summary>
    public BicepValue<string> SecretStoreComponent 
    {
        get { Initialize(); return _secretStoreComponent!; }
        set { Initialize(); _secretStoreComponent!.Assign(value); }
    }
    private BicepValue<string>? _secretStoreComponent;

    /// <summary>
    /// Component version.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerAppConnectedEnvironment.
    /// </summary>
    public ContainerAppConnectedEnvironment? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerAppConnectedEnvironment>? _parent;

    /// <summary>
    /// Creates a new ContainerAppConnectedEnvironmentDaprComponent.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ContainerAppConnectedEnvironmentDaprComponent resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppConnectedEnvironmentDaprComponent.</param>
    public ContainerAppConnectedEnvironmentDaprComponent(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.App/connectedEnvironments/daprComponents", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppConnectedEnvironmentDaprComponent.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _componentType = DefineProperty<string>("ComponentType", ["properties", "componentType"]);
        _ignoreErrors = DefineProperty<bool>("IgnoreErrors", ["properties", "ignoreErrors"]);
        _initTimeout = DefineProperty<string>("InitTimeout", ["properties", "initTimeout"]);
        _metadata = DefineListProperty<ContainerAppDaprMetadata>("Metadata", ["properties", "metadata"]);
        _scopes = DefineListProperty<string>("Scopes", ["properties", "scopes"]);
        _secrets = DefineListProperty<ContainerAppWritableSecret>("Secrets", ["properties", "secrets"]);
        _secretStoreComponent = DefineProperty<string>("SecretStoreComponent", ["properties", "secretStoreComponent"]);
        _version = DefineProperty<string>("Version", ["properties", "version"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerAppConnectedEnvironment>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerAppConnectedEnvironmentDaprComponent resource
    /// versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2022-10-01.
        /// </summary>
        public static readonly string V2022_10_01 = "2022-10-01";
    }

    /// <summary>
    /// Creates a reference to an existing
    /// ContainerAppConnectedEnvironmentDaprComponent.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// ContainerAppConnectedEnvironmentDaprComponent resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppConnectedEnvironmentDaprComponent.</param>
    /// <returns>The existing ContainerAppConnectedEnvironmentDaprComponent resource.</returns>
    public static ContainerAppConnectedEnvironmentDaprComponent FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
