// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.Net;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// ContainerAppConnectedEnvironment.
/// </summary>
public partial class ContainerAppConnectedEnvironment : ProvisionableResource
{
    /// <summary>
    /// Name of the connectedEnvironment.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Custom domain configuration for the environment.
    /// </summary>
    public ContainerAppCustomDomainConfiguration CustomDomainConfiguration 
    {
        get { Initialize(); return _customDomainConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _customDomainConfiguration, value); }
    }
    private ContainerAppCustomDomainConfiguration? _customDomainConfiguration;

    /// <summary>
    /// Application Insights connection string used by Dapr to export Service
    /// to Service communication telemetry.
    /// </summary>
    public BicepValue<string> DaprAIConnectionString 
    {
        get { Initialize(); return _daprAIConnectionString!; }
        set { Initialize(); _daprAIConnectionString!.Assign(value); }
    }
    private BicepValue<string>? _daprAIConnectionString;

    /// <summary>
    /// The complex type of the extended location.
    /// </summary>
    public ContainerAppExtendedLocation ExtendedLocation 
    {
        get { Initialize(); return _extendedLocation!; }
        set { Initialize(); AssignOrReplace(ref _extendedLocation, value); }
    }
    private ContainerAppExtendedLocation? _extendedLocation;

    /// <summary>
    /// Static IP of the connectedEnvironment.
    /// </summary>
    public BicepValue<IPAddress> StaticIP 
    {
        get { Initialize(); return _staticIP!; }
        set { Initialize(); _staticIP!.Assign(value); }
    }
    private BicepValue<IPAddress>? _staticIP;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Default Domain Name for the cluster.
    /// </summary>
    public BicepValue<string> DefaultDomain 
    {
        get { Initialize(); return _defaultDomain!; }
    }
    private BicepValue<string>? _defaultDomain;

    /// <summary>
    /// Any errors that occurred during deployment or deployment validation.
    /// </summary>
    public BicepValue<string> DeploymentErrors 
    {
        get { Initialize(); return _deploymentErrors!; }
    }
    private BicepValue<string>? _deploymentErrors;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the Kubernetes Environment.
    /// </summary>
    public BicepValue<ContainerAppConnectedEnvironmentProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerAppConnectedEnvironmentProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ContainerAppConnectedEnvironment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerAppConnectedEnvironment
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppConnectedEnvironment.</param>
    public ContainerAppConnectedEnvironment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.App/connectedEnvironments", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ContainerAppConnectedEnvironment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _customDomainConfiguration = DefineModelProperty<ContainerAppCustomDomainConfiguration>("CustomDomainConfiguration", ["properties", "customDomainConfiguration"]);
        _daprAIConnectionString = DefineProperty<string>("DaprAIConnectionString", ["properties", "daprAIConnectionString"]);
        _extendedLocation = DefineModelProperty<ContainerAppExtendedLocation>("ExtendedLocation", ["extendedLocation"]);
        _staticIP = DefineProperty<IPAddress>("StaticIP", ["properties", "staticIp"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _defaultDomain = DefineProperty<string>("DefaultDomain", ["properties", "defaultDomain"], isOutput: true);
        _deploymentErrors = DefineProperty<string>("DeploymentErrors", ["properties", "deploymentErrors"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<ContainerAppConnectedEnvironmentProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ContainerAppConnectedEnvironment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2022-10-01.
        /// </summary>
        public static readonly string V2022_10_01 = "2022-10-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerAppConnectedEnvironment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerAppConnectedEnvironment
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppConnectedEnvironment.</param>
    /// <returns>The existing ContainerAppConnectedEnvironment resource.</returns>
    public static ContainerAppConnectedEnvironment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
