// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// ContainerAppAuthConfig.
/// </summary>
public partial class ContainerAppAuthConfig : ProvisionableResource
{
    /// <summary>
    /// Name of the Container App AuthConfig.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The configuration settings of the secrets references of encryption key
    /// and signing key for ContainerApp Service Authentication/Authorization.
    /// </summary>
    public EncryptionSettings EncryptionSettings 
    {
        get { Initialize(); return _encryptionSettings!; }
        set { Initialize(); AssignOrReplace(ref _encryptionSettings, value); }
    }
    private EncryptionSettings? _encryptionSettings;

    /// <summary>
    /// The configuration settings that determines the validation flow of users
    /// using  Service Authentication/Authorization.
    /// </summary>
    public ContainerAppGlobalValidation GlobalValidation 
    {
        get { Initialize(); return _globalValidation!; }
        set { Initialize(); AssignOrReplace(ref _globalValidation, value); }
    }
    private ContainerAppGlobalValidation? _globalValidation;

    /// <summary>
    /// The configuration settings of the HTTP requests for authentication and
    /// authorization requests made against ContainerApp Service
    /// Authentication/Authorization.
    /// </summary>
    public ContainerAppHttpSettings HttpSettings 
    {
        get { Initialize(); return _httpSettings!; }
        set { Initialize(); AssignOrReplace(ref _httpSettings, value); }
    }
    private ContainerAppHttpSettings? _httpSettings;

    /// <summary>
    /// The configuration settings of each of the identity providers used to
    /// configure ContainerApp Service Authentication/Authorization.
    /// </summary>
    public ContainerAppIdentityProvidersConfiguration IdentityProviders 
    {
        get { Initialize(); return _identityProviders!; }
        set { Initialize(); AssignOrReplace(ref _identityProviders, value); }
    }
    private ContainerAppIdentityProvidersConfiguration? _identityProviders;

    /// <summary>
    /// The configuration settings of the login flow of users using
    /// ContainerApp Service Authentication/Authorization.
    /// </summary>
    public ContainerAppLogin Login 
    {
        get { Initialize(); return _login!; }
        set { Initialize(); AssignOrReplace(ref _login, value); }
    }
    private ContainerAppLogin? _login;

    /// <summary>
    /// The configuration settings of the platform of ContainerApp Service
    /// Authentication/Authorization.
    /// </summary>
    public ContainerAppAuthPlatform Platform 
    {
        get { Initialize(); return _platform!; }
        set { Initialize(); AssignOrReplace(ref _platform, value); }
    }
    private ContainerAppAuthPlatform? _platform;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent ContainerApp.
    /// </summary>
    public ContainerApp? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<ContainerApp>? _parent;

    /// <summary>
    /// Creates a new ContainerAppAuthConfig.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerAppAuthConfig resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppAuthConfig.</param>
    public ContainerAppAuthConfig(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.App/containerApps/authConfigs", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppAuthConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _encryptionSettings = DefineModelProperty<EncryptionSettings>("EncryptionSettings", ["properties", "encryptionSettings"]);
        _globalValidation = DefineModelProperty<ContainerAppGlobalValidation>("GlobalValidation", ["properties", "globalValidation"]);
        _httpSettings = DefineModelProperty<ContainerAppHttpSettings>("HttpSettings", ["properties", "httpSettings"]);
        _identityProviders = DefineModelProperty<ContainerAppIdentityProvidersConfiguration>("IdentityProviders", ["properties", "identityProviders"]);
        _login = DefineModelProperty<ContainerAppLogin>("Login", ["properties", "login"]);
        _platform = DefineModelProperty<ContainerAppAuthPlatform>("Platform", ["properties", "platform"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<ContainerApp>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported ContainerAppAuthConfig resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2022-10-01.
        /// </summary>
        public static readonly string V2022_10_01 = "2022-10-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerAppAuthConfig.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerAppAuthConfig resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerAppAuthConfig.</param>
    /// <returns>The existing ContainerAppAuthConfig resource.</returns>
    public static ContainerAppAuthConfig FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
