// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;
using System.Net;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// ContainerApp.
/// </summary>
public partial class ContainerApp : ProvisionableResource
{
    /// <summary>
    /// Name of the Container App.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Non versioned Container App configuration properties.
    /// </summary>
    public ContainerAppConfiguration Configuration 
    {
        get { Initialize(); return _configuration!; }
        set { Initialize(); AssignOrReplace(ref _configuration, value); }
    }
    private ContainerAppConfiguration? _configuration;

    /// <summary>
    /// Resource ID of environment.
    /// </summary>
    public BicepValue<ResourceIdentifier> EnvironmentId 
    {
        get { Initialize(); return _environmentId!; }
        set { Initialize(); _environmentId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _environmentId;

    /// <summary>
    /// The complex type of the extended location.
    /// </summary>
    public ContainerAppExtendedLocation ExtendedLocation 
    {
        get { Initialize(); return _extendedLocation!; }
        set { Initialize(); AssignOrReplace(ref _extendedLocation, value); }
    }
    private ContainerAppExtendedLocation? _extendedLocation;

    /// <summary>
    /// managed identities for the Container App to interact with other Azure
    /// services without maintaining any secrets or credentials in code.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The fully qualified resource ID of the resource that manages this
    /// resource. Indicates if this resource is managed by another Azure
    /// resource. If this is present, complete mode deployment will not delete
    /// the resource if it is removed from the template since it is managed by
    /// another resource.
    /// </summary>
    public BicepValue<string> ManagedBy 
    {
        get { Initialize(); return _managedBy!; }
        set { Initialize(); _managedBy!.Assign(value); }
    }
    private BicepValue<string>? _managedBy;

    /// <summary>
    /// Deprecated. Resource ID of the Container App&apos;s environment.
    /// </summary>
    public BicepValue<ResourceIdentifier> ManagedEnvironmentId 
    {
        get { Initialize(); return _managedEnvironmentId!; }
        set { Initialize(); _managedEnvironmentId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _managedEnvironmentId;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Container App versioned application definition.
    /// </summary>
    public ContainerAppTemplate Template 
    {
        get { Initialize(); return _template!; }
        set { Initialize(); AssignOrReplace(ref _template, value); }
    }
    private ContainerAppTemplate? _template;

    /// <summary>
    /// Workload profile name to pin for container app execution.
    /// </summary>
    public BicepValue<string> WorkloadProfileName 
    {
        get { Initialize(); return _workloadProfileName!; }
        set { Initialize(); _workloadProfileName!.Assign(value); }
    }
    private BicepValue<string>? _workloadProfileName;

    /// <summary>
    /// Id used to verify domain name ownership.
    /// </summary>
    public BicepValue<string> CustomDomainVerificationId 
    {
        get { Initialize(); return _customDomainVerificationId!; }
    }
    private BicepValue<string>? _customDomainVerificationId;

    /// <summary>
    /// The endpoint of the eventstream of the container app.
    /// </summary>
    public BicepValue<Uri> EventStreamEndpoint 
    {
        get { Initialize(); return _eventStreamEndpoint!; }
    }
    private BicepValue<Uri>? _eventStreamEndpoint;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Name of the latest ready revision of the Container App.
    /// </summary>
    public BicepValue<string> LatestReadyRevisionName 
    {
        get { Initialize(); return _latestReadyRevisionName!; }
    }
    private BicepValue<string>? _latestReadyRevisionName;

    /// <summary>
    /// Fully Qualified Domain Name of the latest revision of the Container App.
    /// </summary>
    public BicepValue<string> LatestRevisionFqdn 
    {
        get { Initialize(); return _latestRevisionFqdn!; }
    }
    private BicepValue<string>? _latestRevisionFqdn;

    /// <summary>
    /// Name of the latest revision of the Container App.
    /// </summary>
    public BicepValue<string> LatestRevisionName 
    {
        get { Initialize(); return _latestRevisionName!; }
    }
    private BicepValue<string>? _latestRevisionName;

    /// <summary>
    /// Outbound IP Addresses for container app.
    /// </summary>
    public BicepList<IPAddress> OutboundIPAddressList 
    {
        get { Initialize(); return _outboundIPAddressList!; }
    }
    private BicepList<IPAddress>? _outboundIPAddressList;

    /// <summary>
    /// Provisioning state of the Container App.
    /// </summary>
    public BicepValue<ContainerAppProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ContainerAppProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ContainerApp.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerApp resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerApp.</param>
    public ContainerApp(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.App/containerApps", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerApp.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _configuration = DefineModelProperty<ContainerAppConfiguration>("Configuration", ["properties", "configuration"]);
        _environmentId = DefineProperty<ResourceIdentifier>("EnvironmentId", ["properties", "environmentId"]);
        _extendedLocation = DefineModelProperty<ContainerAppExtendedLocation>("ExtendedLocation", ["extendedLocation"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _managedBy = DefineProperty<string>("ManagedBy", ["managedBy"]);
        _managedEnvironmentId = DefineProperty<ResourceIdentifier>("ManagedEnvironmentId", ["properties", "managedEnvironmentId"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _template = DefineModelProperty<ContainerAppTemplate>("Template", ["properties", "template"]);
        _workloadProfileName = DefineProperty<string>("WorkloadProfileName", ["properties", "workloadProfileName"]);
        _customDomainVerificationId = DefineProperty<string>("CustomDomainVerificationId", ["properties", "customDomainVerificationId"], isOutput: true);
        _eventStreamEndpoint = DefineProperty<Uri>("EventStreamEndpoint", ["properties", "eventStreamEndpoint"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _latestReadyRevisionName = DefineProperty<string>("LatestReadyRevisionName", ["properties", "latestReadyRevisionName"], isOutput: true);
        _latestRevisionFqdn = DefineProperty<string>("LatestRevisionFqdn", ["properties", "latestRevisionFqdn"], isOutput: true);
        _latestRevisionName = DefineProperty<string>("LatestRevisionName", ["properties", "latestRevisionName"], isOutput: true);
        _outboundIPAddressList = DefineListProperty<IPAddress>("OutboundIPAddressList", ["properties", "outboundIpAddresses"], isOutput: true);
        _provisioningState = DefineProperty<ContainerAppProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported ContainerApp resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2022-10-01.
        /// </summary>
        public static readonly string V2022_10_01 = "2022-10-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing ContainerApp.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the ContainerApp resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the ContainerApp.</param>
    /// <returns>The existing ContainerApp resource.</returns>
    public static ContainerApp FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this ContainerApp resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 2, maxLength: 32, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
