// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppContainers;

/// <summary>
/// Built-in AppContainers roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct AppContainersBuiltInRole(string value) : IEquatable<AppContainersBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Grants full access to manage all resources, but does not allow you to
    /// assign roles in Azure RBAC, manage assignments in Azure Blueprints, or
    /// share image galleries.
    /// </summary>
    public static AppContainersBuiltInRole Contributor { get; } = new(ContributorValue);
    internal const string ContributorValue = "b24988ac-6180-42a0-ab88-20f7382dd24c";

    /// <summary>
    /// Grants full access to manage all resources, including the ability to
    /// assign roles in Azure RBAC.
    /// </summary>
    public static AppContainersBuiltInRole Owner { get; } = new(OwnerValue);
    internal const string OwnerValue = "8e3af657-a8ff-443c-a75c-2fe8c4bcb635";

    /// <summary>
    /// View all resources, but does not allow you to make any changes.
    /// </summary>
    public static AppContainersBuiltInRole Reader { get; } = new(ReaderValue);
    internal const string ReaderValue = "acdd72a7-3385-48ef-bd42-f606fba81ae7";

    /// <summary>
    /// Try to get the name of a built-in AppContainers role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in AppContainers role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(AppContainersBuiltInRole value) =>
        value._value switch
        {
            ContributorValue => nameof(Contributor),
            OwnerValue => nameof(Owner),
            ReaderValue => nameof(Reader),
            _ => value._value
        };

    /// <summary>
    /// Determines if two AppContainersBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first AppContainersBuiltInRole to compare.</param>
    /// <param name="right">The second AppContainersBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(AppContainersBuiltInRole left, AppContainersBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two AppContainersBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first AppContainersBuiltInRole to compare.</param>
    /// <param name="right">The second AppContainersBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(AppContainersBuiltInRole left, AppContainersBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a AppContainersBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator AppContainersBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is AppContainersBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(AppContainersBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
