// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppConfiguration;

/// <summary>
/// An API key used for authenticating with a configuration store endpoint.
/// </summary>
public partial class AppConfigurationStoreApiKey : ProvisionableConstruct
{
    /// <summary>
    /// The key ID.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// A name for the key describing its usage.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The value of the key that is used for authentication purposes.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// A connection string that can be used by supporting clients for
    /// authentication.
    /// </summary>
    public BicepValue<string> ConnectionString 
    {
        get { Initialize(); return _connectionString!; }
    }
    private BicepValue<string>? _connectionString;

    /// <summary>
    /// The last time any of the key&apos;s properties were modified.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Whether this key can only be used for read operations.
    /// </summary>
    public BicepValue<bool> IsReadOnly 
    {
        get { Initialize(); return _isReadOnly!; }
    }
    private BicepValue<bool>? _isReadOnly;

    /// <summary>
    /// Creates a new AppConfigurationStoreApiKey.
    /// </summary>
    public AppConfigurationStoreApiKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppConfigurationStoreApiKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _value = DefineProperty<string>("Value", ["value"], isOutput: true, isSecure: true);
        _connectionString = DefineProperty<string>("ConnectionString", ["connectionString"], isOutput: true, isSecure: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["lastModified"], isOutput: true);
        _isReadOnly = DefineProperty<bool>("IsReadOnly", ["readOnly"], isOutput: true);
    }
}
