// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppConfiguration;

/// <summary>
/// The state of a private link service connection.
/// </summary>
public partial class AppConfigurationPrivateLinkServiceConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// The private link service connection status.
    /// </summary>
    public BicepValue<AppConfigurationPrivateLinkServiceConnectionStatus> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<AppConfigurationPrivateLinkServiceConnectionStatus>? _status;

    /// <summary>
    /// The private link service connection description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Any action that is required beyond basic workflow (approve/ reject/
    /// disconnect).
    /// </summary>
    public BicepValue<AppConfigurationActionsRequired> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
    }
    private BicepValue<AppConfigurationActionsRequired>? _actionsRequired;

    /// <summary>
    /// Creates a new AppConfigurationPrivateLinkServiceConnectionState.
    /// </summary>
    public AppConfigurationPrivateLinkServiceConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppConfigurationPrivateLinkServiceConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<AppConfigurationPrivateLinkServiceConnectionStatus>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<AppConfigurationActionsRequired>("ActionsRequired", ["actionsRequired"], isOutput: true);
    }
}
