// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppConfiguration;

/// <summary>
/// A reference to a related private endpoint connection.
/// </summary>
public partial class AppConfigurationPrivateEndpointConnectionReference : ProvisionableConstruct
{
    /// <summary>
    /// The provisioning status of the private endpoint connection.
    /// </summary>
    public BicepValue<AppConfigurationProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<AppConfigurationProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets or sets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateEndpointId 
    {
        get { Initialize(); return _privateEndpointId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateEndpointId;

    /// <summary>
    /// A collection of information about the state of the connection between
    /// service consumer and provider.
    /// </summary>
    public AppConfigurationPrivateLinkServiceConnectionState ConnectionState 
    {
        get { Initialize(); return _connectionState!; }
    }
    private AppConfigurationPrivateLinkServiceConnectionState? _connectionState;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new AppConfigurationPrivateEndpointConnectionReference.
    /// </summary>
    public AppConfigurationPrivateEndpointConnectionReference()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppConfigurationPrivateEndpointConnectionReference.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<AppConfigurationProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _privateEndpointId = DefineProperty<ResourceIdentifier>("PrivateEndpointId", ["properties", "privateEndpoint", "id"], isOutput: true);
        _connectionState = DefineModelProperty<AppConfigurationPrivateLinkServiceConnectionState>("ConnectionState", ["properties", "privateLinkServiceConnectionState"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
