// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppConfiguration;

/// <summary>
/// AppConfigurationStore.
/// </summary>
public partial class AppConfigurationStore : ProvisionableResource
{
    /// <summary>
    /// The name of the configuration store.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Indicates whether the configuration store need to be recovered.
    /// </summary>
    public BicepValue<AppConfigurationCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<AppConfigurationCreateMode>? _createMode;

    /// <summary>
    /// Disables all authentication methods other than AAD authentication.
    /// </summary>
    public BicepValue<bool> DisableLocalAuth 
    {
        get { Initialize(); return _disableLocalAuth!; }
        set { Initialize(); _disableLocalAuth!.Assign(value); }
    }
    private BicepValue<bool>? _disableLocalAuth;

    /// <summary>
    /// Property specifying whether protection against purge is enabled for
    /// this configuration store.
    /// </summary>
    public BicepValue<bool> EnablePurgeProtection 
    {
        get { Initialize(); return _enablePurgeProtection!; }
        set { Initialize(); _enablePurgeProtection!.Assign(value); }
    }
    private BicepValue<bool>? _enablePurgeProtection;

    /// <summary>
    /// Key vault properties.
    /// </summary>
    public AppConfigurationKeyVaultProperties EncryptionKeyVaultProperties 
    {
        get { Initialize(); return _encryptionKeyVaultProperties!; }
        set { Initialize(); AssignOrReplace(ref _encryptionKeyVaultProperties, value); }
    }
    private AppConfigurationKeyVaultProperties? _encryptionKeyVaultProperties;

    /// <summary>
    /// The managed identity information, if configured.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Control permission for data plane traffic coming from public networks
    /// while private endpoint is enabled.
    /// </summary>
    public BicepValue<AppConfigurationPublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<AppConfigurationPublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// The SKU name of the configuration store.
    /// </summary>
    public BicepValue<string> SkuName 
    {
        get { Initialize(); return _skuName!; }
        set { Initialize(); _skuName!.Assign(value); }
    }
    private BicepValue<string>? _skuName;

    /// <summary>
    /// The amount of time in days that the configuration store will be
    /// retained when it is soft deleted.
    /// </summary>
    public BicepValue<int> SoftDeleteRetentionInDays 
    {
        get { Initialize(); return _softDeleteRetentionInDays!; }
        set { Initialize(); _softDeleteRetentionInDays!.Assign(value); }
    }
    private BicepValue<int>? _softDeleteRetentionInDays;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The creation date of configuration store.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// The DNS endpoint where the configuration store API will be available.
    /// </summary>
    public BicepValue<string> Endpoint 
    {
        get { Initialize(); return _endpoint!; }
    }
    private BicepValue<string>? _endpoint;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The list of private endpoint connections that are set up for this
    /// resource.
    /// </summary>
    public BicepList<AppConfigurationPrivateEndpointConnectionReference> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<AppConfigurationPrivateEndpointConnectionReference>? _privateEndpointConnections;

    /// <summary>
    /// The provisioning state of the configuration store.
    /// </summary>
    public BicepValue<AppConfigurationProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<AppConfigurationProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new AppConfigurationStore.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppConfigurationStore resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppConfigurationStore.</param>
    public AppConfigurationStore(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.AppConfiguration/configurationStores", resourceVersion ?? "2024-05-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppConfigurationStore.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _createMode = DefineProperty<AppConfigurationCreateMode>("CreateMode", ["properties", "createMode"]);
        _disableLocalAuth = DefineProperty<bool>("DisableLocalAuth", ["properties", "disableLocalAuth"]);
        _enablePurgeProtection = DefineProperty<bool>("EnablePurgeProtection", ["properties", "enablePurgeProtection"]);
        _encryptionKeyVaultProperties = DefineModelProperty<AppConfigurationKeyVaultProperties>("EncryptionKeyVaultProperties", ["properties", "encryption", "keyVaultProperties"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _publicNetworkAccess = DefineProperty<AppConfigurationPublicNetworkAccess>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _skuName = DefineProperty<string>("SkuName", ["sku", "name"]);
        _softDeleteRetentionInDays = DefineProperty<int>("SoftDeleteRetentionInDays", ["properties", "softDeleteRetentionInDays"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationDate"], isOutput: true);
        _endpoint = DefineProperty<string>("Endpoint", ["properties", "endpoint"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<AppConfigurationPrivateEndpointConnectionReference>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<AppConfigurationProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported AppConfigurationStore resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-05-01.
        /// </summary>
        public static readonly string V2024_05_01 = "2024-05-01";

        /// <summary>
        /// 2023-03-01.
        /// </summary>
        public static readonly string V2023_03_01 = "2023-03-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-10-01.
        /// </summary>
        public static readonly string V2019_10_01 = "2019-10-01";
    }

    /// <summary>
    /// Creates a reference to an existing AppConfigurationStore.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppConfigurationStore resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppConfigurationStore.</param>
    /// <returns>The existing AppConfigurationStore resource.</returns>
    public static AppConfigurationStore FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this AppConfigurationStore resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 5, maxLength: 50, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);

    /// <summary>
    /// Get access keys for this AppConfigurationStore resource.
    /// </summary>
    /// <returns>The keys for this AppConfigurationStore resource.</returns>
    public BicepList<AppConfigurationStoreApiKey> GetKeys()
    {
        return BicepList<AppConfigurationStoreApiKey>.FromExpression(
            e => { AppConfigurationStoreApiKey key = new(); ((IBicepValue)key).Expression = e; return key; },
            new MemberExpression(new FunctionCallExpression(new MemberExpression(new IdentifierExpression(BicepIdentifier), "listKeys")), "keys"));
    }

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this AppConfigurationStore.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(AppConfigurationBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{AppConfigurationBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// AppConfigurationStore.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(AppConfigurationBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{AppConfigurationBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
