// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppConfiguration;

/// <summary>
/// AppConfigurationKeyValue.
/// </summary>
public partial class AppConfigurationKeyValue : ProvisionableResource
{
    /// <summary>
    /// Identifier of key and label combination. Key and label are joined by $
    /// character. Label is optional.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The content type of the key-value&apos;s value.             Providing a
    /// proper content-type can enable transformations of values when they are
    /// retrieved by applications.
    /// </summary>
    public BicepValue<string> ContentType 
    {
        get { Initialize(); return _contentType!; }
        set { Initialize(); _contentType!.Assign(value); }
    }
    private BicepValue<string>? _contentType;

    /// <summary>
    /// A dictionary of tags that can help identify what a key-value may be
    /// applicable for.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The value of the key-value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// An ETag indicating the state of a key-value within a configuration
    /// store.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// A value indicating whether the key-value is locked.             A
    /// locked key-value may not be modified until it is unlocked.
    /// </summary>
    public BicepValue<bool> IsLocked 
    {
        get { Initialize(); return _isLocked!; }
    }
    private BicepValue<bool>? _isLocked;

    /// <summary>
    /// The primary identifier of a key-value.             The key is used in
    /// unison with the label to uniquely identify a key-value.
    /// </summary>
    public BicepValue<string> Key 
    {
        get { Initialize(); return _key!; }
    }
    private BicepValue<string>? _key;

    /// <summary>
    /// A value used to group key-values.             The label is used in
    /// unison with the key to uniquely identify a key-value.
    /// </summary>
    public BicepValue<string> Label 
    {
        get { Initialize(); return _label!; }
    }
    private BicepValue<string>? _label;

    /// <summary>
    /// The last time a modifying operation was performed on the given
    /// key-value.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent AppConfigurationStore.
    /// </summary>
    public AppConfigurationStore? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<AppConfigurationStore>? _parent;

    /// <summary>
    /// Creates a new AppConfigurationKeyValue.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppConfigurationKeyValue resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppConfigurationKeyValue.</param>
    public AppConfigurationKeyValue(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.AppConfiguration/configurationStores/keyValues", resourceVersion ?? "2024-05-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppConfigurationKeyValue.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _contentType = DefineProperty<string>("ContentType", ["properties", "contentType"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["properties", "tags"]);
        _value = DefineProperty<string>("Value", ["properties", "value"]);
        _eTag = DefineProperty<ETag>("ETag", ["properties", "eTag"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isLocked = DefineProperty<bool>("IsLocked", ["properties", "locked"], isOutput: true);
        _key = DefineProperty<string>("Key", ["properties", "key"], isOutput: true);
        _label = DefineProperty<string>("Label", ["properties", "label"], isOutput: true);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["properties", "lastModified"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<AppConfigurationStore>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported AppConfigurationKeyValue resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-05-01.
        /// </summary>
        public static readonly string V2024_05_01 = "2024-05-01";

        /// <summary>
        /// 2023-03-01.
        /// </summary>
        public static readonly string V2023_03_01 = "2023-03-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing AppConfigurationKeyValue.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppConfigurationKeyValue resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppConfigurationKeyValue.</param>
    /// <returns>The existing AppConfigurationKeyValue resource.</returns>
    public static AppConfigurationKeyValue FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
