// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppConfiguration;

/// <summary>
/// Built-in AppConfiguration roles that you can assign to users, groups,
/// service principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct AppConfigurationBuiltInRole(string value) : IEquatable<AppConfigurationBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Allows full access to App Configuration data.
    /// </summary>
    public static AppConfigurationBuiltInRole AppConfigurationDataOwner { get; } = new(AppConfigurationDataOwnerValue);
    internal const string AppConfigurationDataOwnerValue = "5ae67dd6-50cb-40e7-96ff-dc2bfa4b606b";

    /// <summary>
    /// Allows read access to App Configuration data.
    /// </summary>
    public static AppConfigurationBuiltInRole AppConfigurationDataReader { get; } = new(AppConfigurationDataReaderValue);
    internal const string AppConfigurationDataReaderValue = "516239f1-63e1-4d78-a4de-a74fb236a071";

    /// <summary>
    /// Try to get the name of a built-in AppConfiguration role from its ID
    /// value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in AppConfiguration role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(AppConfigurationBuiltInRole value) =>
        value._value switch
        {
            AppConfigurationDataOwnerValue => nameof(AppConfigurationDataOwner),
            AppConfigurationDataReaderValue => nameof(AppConfigurationDataReader),
            _ => value._value
        };

    /// <summary>
    /// Determines if two AppConfigurationBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first AppConfigurationBuiltInRole to compare.</param>
    /// <param name="right">The second AppConfigurationBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(AppConfigurationBuiltInRole left, AppConfigurationBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two AppConfigurationBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first AppConfigurationBuiltInRole to compare.</param>
    /// <param name="right">The second AppConfigurationBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(AppConfigurationBuiltInRole left, AppConfigurationBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a AppConfigurationBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator AppConfigurationBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is AppConfigurationBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(AppConfigurationBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
