// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The TrafficRegionCategory. </summary>
    public readonly partial struct TrafficRegionCategory : IEquatable<TrafficRegionCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TrafficRegionCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TrafficRegionCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string CanaryValue = "Canary";
        private const string LowTrafficValue = "LowTraffic";
        private const string MediumTrafficValue = "MediumTraffic";
        private const string HighTrafficValue = "HighTraffic";
        private const string NoneValue = "None";
        private const string RestOfTheWorldGroupOneValue = "RestOfTheWorldGroupOne";
        private const string RestOfTheWorldGroupTwoValue = "RestOfTheWorldGroupTwo";

        /// <summary> NotSpecified. </summary>
        public static TrafficRegionCategory NotSpecified { get; } = new TrafficRegionCategory(NotSpecifiedValue);
        /// <summary> Canary. </summary>
        public static TrafficRegionCategory Canary { get; } = new TrafficRegionCategory(CanaryValue);
        /// <summary> LowTraffic. </summary>
        public static TrafficRegionCategory LowTraffic { get; } = new TrafficRegionCategory(LowTrafficValue);
        /// <summary> MediumTraffic. </summary>
        public static TrafficRegionCategory MediumTraffic { get; } = new TrafficRegionCategory(MediumTrafficValue);
        /// <summary> HighTraffic. </summary>
        public static TrafficRegionCategory HighTraffic { get; } = new TrafficRegionCategory(HighTrafficValue);
        /// <summary> None. </summary>
        public static TrafficRegionCategory None { get; } = new TrafficRegionCategory(NoneValue);
        /// <summary> RestOfTheWorldGroupOne. </summary>
        public static TrafficRegionCategory RestOfTheWorldGroupOne { get; } = new TrafficRegionCategory(RestOfTheWorldGroupOneValue);
        /// <summary> RestOfTheWorldGroupTwo. </summary>
        public static TrafficRegionCategory RestOfTheWorldGroupTwo { get; } = new TrafficRegionCategory(RestOfTheWorldGroupTwoValue);
        /// <summary> Determines if two <see cref="TrafficRegionCategory"/> values are the same. </summary>
        public static bool operator ==(TrafficRegionCategory left, TrafficRegionCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TrafficRegionCategory"/> values are not the same. </summary>
        public static bool operator !=(TrafficRegionCategory left, TrafficRegionCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TrafficRegionCategory"/>. </summary>
        public static implicit operator TrafficRegionCategory(string value) => new TrafficRegionCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TrafficRegionCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TrafficRegionCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
