// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ThirdPartyProviderAuthorization. </summary>
    public partial class ThirdPartyProviderAuthorization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ThirdPartyProviderAuthorization"/>. </summary>
        public ThirdPartyProviderAuthorization()
        {
            Authorizations = new ChangeTrackingList<LightHouseAuthorization>();
        }

        /// <summary> Initializes a new instance of <see cref="ThirdPartyProviderAuthorization"/>. </summary>
        /// <param name="authorizations"></param>
        /// <param name="managedByTenantId"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ThirdPartyProviderAuthorization(IList<LightHouseAuthorization> authorizations, string managedByTenantId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Authorizations = authorizations;
            ManagedByTenantId = managedByTenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the authorizations. </summary>
        public IList<LightHouseAuthorization> Authorizations { get; }
        /// <summary> Gets or sets the managed by tenant id. </summary>
        public string ManagedByTenantId { get; set; }
    }
}
