// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The TemplateDeploymentCapability. </summary>
    public readonly partial struct TemplateDeploymentCapability : IEquatable<TemplateDeploymentCapability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TemplateDeploymentCapability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TemplateDeploymentCapability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string PreflightValue = "Preflight";

        /// <summary> Default. </summary>
        public static TemplateDeploymentCapability Default { get; } = new TemplateDeploymentCapability(DefaultValue);
        /// <summary> Preflight. </summary>
        public static TemplateDeploymentCapability Preflight { get; } = new TemplateDeploymentCapability(PreflightValue);
        /// <summary> Determines if two <see cref="TemplateDeploymentCapability"/> values are the same. </summary>
        public static bool operator ==(TemplateDeploymentCapability left, TemplateDeploymentCapability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TemplateDeploymentCapability"/> values are not the same. </summary>
        public static bool operator !=(TemplateDeploymentCapability left, TemplateDeploymentCapability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TemplateDeploymentCapability"/>. </summary>
        public static implicit operator TemplateDeploymentCapability(string value) => new TemplateDeploymentCapability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TemplateDeploymentCapability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TemplateDeploymentCapability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
