// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The SubscriptionTransitioningState. </summary>
    public readonly partial struct SubscriptionTransitioningState : IEquatable<SubscriptionTransitioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionTransitioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionTransitioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteredValue = "Registered";
        private const string UnregisteredValue = "Unregistered";
        private const string WarnedValue = "Warned";
        private const string SuspendedValue = "Suspended";
        private const string DeletedValue = "Deleted";
        private const string WarnedToRegisteredValue = "WarnedToRegistered";
        private const string WarnedToSuspendedValue = "WarnedToSuspended";
        private const string WarnedToDeletedValue = "WarnedToDeleted";
        private const string WarnedToUnregisteredValue = "WarnedToUnregistered";
        private const string SuspendedToRegisteredValue = "SuspendedToRegistered";
        private const string SuspendedToWarnedValue = "SuspendedToWarned";
        private const string SuspendedToDeletedValue = "SuspendedToDeleted";
        private const string SuspendedToUnregisteredValue = "SuspendedToUnregistered";

        /// <summary> Registered. </summary>
        public static SubscriptionTransitioningState Registered { get; } = new SubscriptionTransitioningState(RegisteredValue);
        /// <summary> Unregistered. </summary>
        public static SubscriptionTransitioningState Unregistered { get; } = new SubscriptionTransitioningState(UnregisteredValue);
        /// <summary> Warned. </summary>
        public static SubscriptionTransitioningState Warned { get; } = new SubscriptionTransitioningState(WarnedValue);
        /// <summary> Suspended. </summary>
        public static SubscriptionTransitioningState Suspended { get; } = new SubscriptionTransitioningState(SuspendedValue);
        /// <summary> Deleted. </summary>
        public static SubscriptionTransitioningState Deleted { get; } = new SubscriptionTransitioningState(DeletedValue);
        /// <summary> WarnedToRegistered. </summary>
        public static SubscriptionTransitioningState WarnedToRegistered { get; } = new SubscriptionTransitioningState(WarnedToRegisteredValue);
        /// <summary> WarnedToSuspended. </summary>
        public static SubscriptionTransitioningState WarnedToSuspended { get; } = new SubscriptionTransitioningState(WarnedToSuspendedValue);
        /// <summary> WarnedToDeleted. </summary>
        public static SubscriptionTransitioningState WarnedToDeleted { get; } = new SubscriptionTransitioningState(WarnedToDeletedValue);
        /// <summary> WarnedToUnregistered. </summary>
        public static SubscriptionTransitioningState WarnedToUnregistered { get; } = new SubscriptionTransitioningState(WarnedToUnregisteredValue);
        /// <summary> SuspendedToRegistered. </summary>
        public static SubscriptionTransitioningState SuspendedToRegistered { get; } = new SubscriptionTransitioningState(SuspendedToRegisteredValue);
        /// <summary> SuspendedToWarned. </summary>
        public static SubscriptionTransitioningState SuspendedToWarned { get; } = new SubscriptionTransitioningState(SuspendedToWarnedValue);
        /// <summary> SuspendedToDeleted. </summary>
        public static SubscriptionTransitioningState SuspendedToDeleted { get; } = new SubscriptionTransitioningState(SuspendedToDeletedValue);
        /// <summary> SuspendedToUnregistered. </summary>
        public static SubscriptionTransitioningState SuspendedToUnregistered { get; } = new SubscriptionTransitioningState(SuspendedToUnregisteredValue);
        /// <summary> Determines if two <see cref="SubscriptionTransitioningState"/> values are the same. </summary>
        public static bool operator ==(SubscriptionTransitioningState left, SubscriptionTransitioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionTransitioningState"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionTransitioningState left, SubscriptionTransitioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionTransitioningState"/>. </summary>
        public static implicit operator SubscriptionTransitioningState(string value) => new SubscriptionTransitioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionTransitioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionTransitioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
