// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The SubscriptionReregistrationResult. </summary>
    public readonly partial struct SubscriptionReregistrationResult : IEquatable<SubscriptionReregistrationResult>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionReregistrationResult"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionReregistrationResult(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotApplicableValue = "NotApplicable";
        private const string ConditionalUpdateValue = "ConditionalUpdate";
        private const string ForcedUpdateValue = "ForcedUpdate";
        private const string FailedValue = "Failed";

        /// <summary> NotApplicable. </summary>
        public static SubscriptionReregistrationResult NotApplicable { get; } = new SubscriptionReregistrationResult(NotApplicableValue);
        /// <summary> ConditionalUpdate. </summary>
        public static SubscriptionReregistrationResult ConditionalUpdate { get; } = new SubscriptionReregistrationResult(ConditionalUpdateValue);
        /// <summary> ForcedUpdate. </summary>
        public static SubscriptionReregistrationResult ForcedUpdate { get; } = new SubscriptionReregistrationResult(ForcedUpdateValue);
        /// <summary> Failed. </summary>
        public static SubscriptionReregistrationResult Failed { get; } = new SubscriptionReregistrationResult(FailedValue);
        /// <summary> Determines if two <see cref="SubscriptionReregistrationResult"/> values are the same. </summary>
        public static bool operator ==(SubscriptionReregistrationResult left, SubscriptionReregistrationResult right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionReregistrationResult"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionReregistrationResult left, SubscriptionReregistrationResult right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionReregistrationResult"/>. </summary>
        public static implicit operator SubscriptionReregistrationResult(string value) => new SubscriptionReregistrationResult(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionReregistrationResult other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionReregistrationResult other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
