// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub.Models
{
    public partial class SubscriptionLifecycleNotificationSpecifications : IUtf8JsonSerializable, IJsonModel<SubscriptionLifecycleNotificationSpecifications>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SubscriptionLifecycleNotificationSpecifications>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SubscriptionLifecycleNotificationSpecifications>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionLifecycleNotificationSpecifications>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SubscriptionLifecycleNotificationSpecifications)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(SubscriptionStateOverrideActions))
            {
                writer.WritePropertyName("subscriptionStateOverrideActions"u8);
                writer.WriteStartArray();
                foreach (var item in SubscriptionStateOverrideActions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SoftDeleteTtl))
            {
                writer.WritePropertyName("softDeleteTTL"u8);
                writer.WriteStringValue(SoftDeleteTtl.Value, "P");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SubscriptionLifecycleNotificationSpecifications IJsonModel<SubscriptionLifecycleNotificationSpecifications>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionLifecycleNotificationSpecifications>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SubscriptionLifecycleNotificationSpecifications)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSubscriptionLifecycleNotificationSpecifications(document.RootElement, options);
        }

        internal static SubscriptionLifecycleNotificationSpecifications DeserializeSubscriptionLifecycleNotificationSpecifications(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<SubscriptionStateOverrideAction> subscriptionStateOverrideActions = default;
            TimeSpan? softDeleteTtl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("subscriptionStateOverrideActions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SubscriptionStateOverrideAction> array = new List<SubscriptionStateOverrideAction>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SubscriptionStateOverrideAction.DeserializeSubscriptionStateOverrideAction(item, options));
                    }
                    subscriptionStateOverrideActions = array;
                    continue;
                }
                if (property.NameEquals("softDeleteTTL"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    softDeleteTtl = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SubscriptionLifecycleNotificationSpecifications(subscriptionStateOverrideActions ?? new ChangeTrackingList<SubscriptionStateOverrideAction>(), softDeleteTtl, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SubscriptionLifecycleNotificationSpecifications>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionLifecycleNotificationSpecifications>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SubscriptionLifecycleNotificationSpecifications)} does not support writing '{options.Format}' format.");
            }
        }

        SubscriptionLifecycleNotificationSpecifications IPersistableModel<SubscriptionLifecycleNotificationSpecifications>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SubscriptionLifecycleNotificationSpecifications>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSubscriptionLifecycleNotificationSpecifications(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SubscriptionLifecycleNotificationSpecifications)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SubscriptionLifecycleNotificationSpecifications>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
