// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceTypeSkuSetting. </summary>
    public partial class ResourceTypeSkuSetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuSetting"/>. </summary>
        /// <param name="name"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ResourceTypeSkuSetting(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            Locations = new ChangeTrackingList<string>();
            LocationInfo = new ChangeTrackingList<ResourceTypeSkuLocationInfo>();
            RequiredQuotaIds = new ChangeTrackingList<string>();
            RequiredFeatures = new ChangeTrackingList<string>();
            Costs = new ChangeTrackingList<ResourceTypeSkuCost>();
            Capabilities = new ChangeTrackingList<ResourceSkuCapability>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuSetting"/>. </summary>
        /// <param name="name"></param>
        /// <param name="tier"></param>
        /// <param name="size"></param>
        /// <param name="family"></param>
        /// <param name="kind"></param>
        /// <param name="locations"></param>
        /// <param name="locationInfo"></param>
        /// <param name="requiredQuotaIds"></param>
        /// <param name="requiredFeatures"></param>
        /// <param name="capacity"></param>
        /// <param name="costs"></param>
        /// <param name="capabilities"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceTypeSkuSetting(string name, string tier, string size, string family, string kind, IList<string> locations, IList<ResourceTypeSkuLocationInfo> locationInfo, IList<string> requiredQuotaIds, IList<string> requiredFeatures, ResourceTypeSkuCapacity capacity, IList<ResourceTypeSkuCost> costs, IList<ResourceSkuCapability> capabilities, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Tier = tier;
            Size = size;
            Family = family;
            Kind = kind;
            Locations = locations;
            LocationInfo = locationInfo;
            RequiredQuotaIds = requiredQuotaIds;
            RequiredFeatures = requiredFeatures;
            Capacity = capacity;
            Costs = costs;
            Capabilities = capabilities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuSetting"/> for deserialization. </summary>
        internal ResourceTypeSkuSetting()
        {
        }

        /// <summary> Gets or sets the name. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets the tier. </summary>
        public string Tier { get; set; }
        /// <summary> Gets or sets the size. </summary>
        public string Size { get; set; }
        /// <summary> Gets or sets the family. </summary>
        public string Family { get; set; }
        /// <summary> Gets or sets the kind. </summary>
        public string Kind { get; set; }
        /// <summary> Gets the locations. </summary>
        public IList<string> Locations { get; }
        /// <summary> Gets the location info. </summary>
        public IList<ResourceTypeSkuLocationInfo> LocationInfo { get; }
        /// <summary> Gets the required quota ids. </summary>
        public IList<string> RequiredQuotaIds { get; }
        /// <summary> Gets the required features. </summary>
        public IList<string> RequiredFeatures { get; }
        /// <summary> Gets or sets the capacity. </summary>
        public ResourceTypeSkuCapacity Capacity { get; set; }
        /// <summary> Gets the costs. </summary>
        public IList<ResourceTypeSkuCost> Costs { get; }
        /// <summary> Gets the capabilities. </summary>
        public IList<ResourceSkuCapability> Capabilities { get; }
    }
}
