// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceTypeSkuScaleType. </summary>
    public readonly partial struct ResourceTypeSkuScaleType : IEquatable<ResourceTypeSkuScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceTypeSkuScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> None. </summary>
        public static ResourceTypeSkuScaleType None { get; } = new ResourceTypeSkuScaleType(NoneValue);
        /// <summary> Manual. </summary>
        public static ResourceTypeSkuScaleType Manual { get; } = new ResourceTypeSkuScaleType(ManualValue);
        /// <summary> Automatic. </summary>
        public static ResourceTypeSkuScaleType Automatic { get; } = new ResourceTypeSkuScaleType(AutomaticValue);
        /// <summary> Determines if two <see cref="ResourceTypeSkuScaleType"/> values are the same. </summary>
        public static bool operator ==(ResourceTypeSkuScaleType left, ResourceTypeSkuScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceTypeSkuScaleType"/> values are not the same. </summary>
        public static bool operator !=(ResourceTypeSkuScaleType left, ResourceTypeSkuScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceTypeSkuScaleType"/>. </summary>
        public static implicit operator ResourceTypeSkuScaleType(string value) => new ResourceTypeSkuScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceTypeSkuScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceTypeSkuScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
