// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceTypeSkuCost. </summary>
    public partial class ResourceTypeSkuCost
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuCost"/>. </summary>
        /// <param name="meterId"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="meterId"/> is null. </exception>
        public ResourceTypeSkuCost(string meterId)
        {
            Argument.AssertNotNull(meterId, nameof(meterId));

            MeterId = meterId;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuCost"/>. </summary>
        /// <param name="meterId"></param>
        /// <param name="quantity"></param>
        /// <param name="extendedUnit"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceTypeSkuCost(string meterId, int? quantity, string extendedUnit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MeterId = meterId;
            Quantity = quantity;
            ExtendedUnit = extendedUnit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceTypeSkuCost"/> for deserialization. </summary>
        internal ResourceTypeSkuCost()
        {
        }

        /// <summary> Gets or sets the meter id. </summary>
        public string MeterId { get; set; }
        /// <summary> Gets or sets the quantity. </summary>
        public int? Quantity { get; set; }
        /// <summary> Gets or sets the extended unit. </summary>
        public string ExtendedUnit { get; set; }
    }
}
