// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceTypeRegistrationRegionality. </summary>
    public readonly partial struct ResourceTypeRegistrationRegionality : IEquatable<ResourceTypeRegistrationRegionality>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeRegistrationRegionality"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceTypeRegistrationRegionality(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string GlobalValue = "Global";
        private const string RegionalValue = "Regional";

        /// <summary> NotSpecified. </summary>
        public static ResourceTypeRegistrationRegionality NotSpecified { get; } = new ResourceTypeRegistrationRegionality(NotSpecifiedValue);
        /// <summary> Global. </summary>
        public static ResourceTypeRegistrationRegionality Global { get; } = new ResourceTypeRegistrationRegionality(GlobalValue);
        /// <summary> Regional. </summary>
        public static ResourceTypeRegistrationRegionality Regional { get; } = new ResourceTypeRegistrationRegionality(RegionalValue);
        /// <summary> Determines if two <see cref="ResourceTypeRegistrationRegionality"/> values are the same. </summary>
        public static bool operator ==(ResourceTypeRegistrationRegionality left, ResourceTypeRegistrationRegionality right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceTypeRegistrationRegionality"/> values are not the same. </summary>
        public static bool operator !=(ResourceTypeRegistrationRegionality left, ResourceTypeRegistrationRegionality right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceTypeRegistrationRegionality"/>. </summary>
        public static implicit operator ResourceTypeRegistrationRegionality(string value) => new ResourceTypeRegistrationRegionality(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceTypeRegistrationRegionality other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceTypeRegistrationRegionality other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
