// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceTypeExtensionCategory. </summary>
    public readonly partial struct ResourceTypeExtensionCategory : IEquatable<ResourceTypeExtensionCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceTypeExtensionCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceTypeExtensionCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ResourceCreationValidateValue = "ResourceCreationValidate";
        private const string ResourceCreationBeginValue = "ResourceCreationBegin";
        private const string ResourceCreationCompletedValue = "ResourceCreationCompleted";
        private const string ResourceReadValidateValue = "ResourceReadValidate";
        private const string ResourceReadBeginValue = "ResourceReadBegin";
        private const string ResourcePatchValidateValue = "ResourcePatchValidate";
        private const string ResourcePatchCompletedValue = "ResourcePatchCompleted";
        private const string ResourceDeletionValidateValue = "ResourceDeletionValidate";
        private const string ResourceDeletionBeginValue = "ResourceDeletionBegin";
        private const string ResourceDeletionCompletedValue = "ResourceDeletionCompleted";
        private const string ResourcePostActionValue = "ResourcePostAction";
        private const string SubscriptionLifecycleNotificationValue = "SubscriptionLifecycleNotification";
        private const string ResourcePatchBeginValue = "ResourcePatchBegin";
        private const string ResourceMoveBeginValue = "ResourceMoveBegin";
        private const string ResourceMoveCompletedValue = "ResourceMoveCompleted";

        /// <summary> NotSpecified. </summary>
        public static ResourceTypeExtensionCategory NotSpecified { get; } = new ResourceTypeExtensionCategory(NotSpecifiedValue);
        /// <summary> ResourceCreationValidate. </summary>
        public static ResourceTypeExtensionCategory ResourceCreationValidate { get; } = new ResourceTypeExtensionCategory(ResourceCreationValidateValue);
        /// <summary> ResourceCreationBegin. </summary>
        public static ResourceTypeExtensionCategory ResourceCreationBegin { get; } = new ResourceTypeExtensionCategory(ResourceCreationBeginValue);
        /// <summary> ResourceCreationCompleted. </summary>
        public static ResourceTypeExtensionCategory ResourceCreationCompleted { get; } = new ResourceTypeExtensionCategory(ResourceCreationCompletedValue);
        /// <summary> ResourceReadValidate. </summary>
        public static ResourceTypeExtensionCategory ResourceReadValidate { get; } = new ResourceTypeExtensionCategory(ResourceReadValidateValue);
        /// <summary> ResourceReadBegin. </summary>
        public static ResourceTypeExtensionCategory ResourceReadBegin { get; } = new ResourceTypeExtensionCategory(ResourceReadBeginValue);
        /// <summary> ResourcePatchValidate. </summary>
        public static ResourceTypeExtensionCategory ResourcePatchValidate { get; } = new ResourceTypeExtensionCategory(ResourcePatchValidateValue);
        /// <summary> ResourcePatchCompleted. </summary>
        public static ResourceTypeExtensionCategory ResourcePatchCompleted { get; } = new ResourceTypeExtensionCategory(ResourcePatchCompletedValue);
        /// <summary> ResourceDeletionValidate. </summary>
        public static ResourceTypeExtensionCategory ResourceDeletionValidate { get; } = new ResourceTypeExtensionCategory(ResourceDeletionValidateValue);
        /// <summary> ResourceDeletionBegin. </summary>
        public static ResourceTypeExtensionCategory ResourceDeletionBegin { get; } = new ResourceTypeExtensionCategory(ResourceDeletionBeginValue);
        /// <summary> ResourceDeletionCompleted. </summary>
        public static ResourceTypeExtensionCategory ResourceDeletionCompleted { get; } = new ResourceTypeExtensionCategory(ResourceDeletionCompletedValue);
        /// <summary> ResourcePostAction. </summary>
        public static ResourceTypeExtensionCategory ResourcePostAction { get; } = new ResourceTypeExtensionCategory(ResourcePostActionValue);
        /// <summary> SubscriptionLifecycleNotification. </summary>
        public static ResourceTypeExtensionCategory SubscriptionLifecycleNotification { get; } = new ResourceTypeExtensionCategory(SubscriptionLifecycleNotificationValue);
        /// <summary> ResourcePatchBegin. </summary>
        public static ResourceTypeExtensionCategory ResourcePatchBegin { get; } = new ResourceTypeExtensionCategory(ResourcePatchBeginValue);
        /// <summary> ResourceMoveBegin. </summary>
        public static ResourceTypeExtensionCategory ResourceMoveBegin { get; } = new ResourceTypeExtensionCategory(ResourceMoveBeginValue);
        /// <summary> ResourceMoveCompleted. </summary>
        public static ResourceTypeExtensionCategory ResourceMoveCompleted { get; } = new ResourceTypeExtensionCategory(ResourceMoveCompletedValue);
        /// <summary> Determines if two <see cref="ResourceTypeExtensionCategory"/> values are the same. </summary>
        public static bool operator ==(ResourceTypeExtensionCategory left, ResourceTypeExtensionCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceTypeExtensionCategory"/> values are not the same. </summary>
        public static bool operator !=(ResourceTypeExtensionCategory left, ResourceTypeExtensionCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceTypeExtensionCategory"/>. </summary>
        public static implicit operator ResourceTypeExtensionCategory(string value) => new ResourceTypeExtensionCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceTypeExtensionCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceTypeExtensionCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
