// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceProviderType. </summary>
    public readonly partial struct ResourceProviderType : IEquatable<ResourceProviderType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceProviderType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceProviderType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string InternalValue = "Internal";
        private const string ExternalValue = "External";
        private const string HiddenValue = "Hidden";
        private const string RegistrationFreeValue = "RegistrationFree";
        private const string LegacyRegistrationRequiredValue = "LegacyRegistrationRequired";
        private const string TenantOnlyValue = "TenantOnly";
        private const string AuthorizationFreeValue = "AuthorizationFree";

        /// <summary> NotSpecified. </summary>
        public static ResourceProviderType NotSpecified { get; } = new ResourceProviderType(NotSpecifiedValue);
        /// <summary> Internal. </summary>
        public static ResourceProviderType Internal { get; } = new ResourceProviderType(InternalValue);
        /// <summary> External. </summary>
        public static ResourceProviderType External { get; } = new ResourceProviderType(ExternalValue);
        /// <summary> Hidden. </summary>
        public static ResourceProviderType Hidden { get; } = new ResourceProviderType(HiddenValue);
        /// <summary> RegistrationFree. </summary>
        public static ResourceProviderType RegistrationFree { get; } = new ResourceProviderType(RegistrationFreeValue);
        /// <summary> LegacyRegistrationRequired. </summary>
        public static ResourceProviderType LegacyRegistrationRequired { get; } = new ResourceProviderType(LegacyRegistrationRequiredValue);
        /// <summary> TenantOnly. </summary>
        public static ResourceProviderType TenantOnly { get; } = new ResourceProviderType(TenantOnlyValue);
        /// <summary> AuthorizationFree. </summary>
        public static ResourceProviderType AuthorizationFree { get; } = new ResourceProviderType(AuthorizationFreeValue);
        /// <summary> Determines if two <see cref="ResourceProviderType"/> values are the same. </summary>
        public static bool operator ==(ResourceProviderType left, ResourceProviderType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceProviderType"/> values are not the same. </summary>
        public static bool operator !=(ResourceProviderType left, ResourceProviderType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceProviderType"/>. </summary>
        public static implicit operator ResourceProviderType(string value) => new ResourceProviderType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceProviderType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceProviderType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
