// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceProviderManifest. </summary>
    public partial class ResourceProviderManifest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceProviderManifest"/>. </summary>
        internal ResourceProviderManifest()
        {
            ProviderAuthorizations = new ChangeTrackingList<ResourceProviderAuthorization>();
            RequiredFeatures = new ChangeTrackingList<string>();
            ResourceTypes = new ChangeTrackingList<ProviderResourceType>();
            Capabilities = new ChangeTrackingList<ResourceProviderCapabilities>();
            GlobalNotificationEndpoints = new ChangeTrackingList<ResourceProviderEndpoint>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceProviderManifest"/>. </summary>
        /// <param name="providerAuthentication"></param>
        /// <param name="providerAuthorizations"></param>
        /// <param name="namespace"></param>
        /// <param name="providerVersion"></param>
        /// <param name="providerType"></param>
        /// <param name="requiredFeatures"></param>
        /// <param name="featuresRule"></param>
        /// <param name="requestHeaderOptions"></param>
        /// <param name="resourceTypes"></param>
        /// <param name="management"></param>
        /// <param name="capabilities"></param>
        /// <param name="metadata"> Anything. </param>
        /// <param name="globalNotificationEndpoints"></param>
        /// <param name="reRegisterSubscriptionMetadata"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceProviderManifest(ResourceProviderAuthentication providerAuthentication, IReadOnlyList<ResourceProviderAuthorization> providerAuthorizations, string @namespace, string providerVersion, ResourceProviderType? providerType, IReadOnlyList<string> requiredFeatures, FeaturesRule featuresRule, RequestHeaderOptions requestHeaderOptions, IReadOnlyList<ProviderResourceType> resourceTypes, ResourceProviderManagement management, IReadOnlyList<ResourceProviderCapabilities> capabilities, BinaryData metadata, IReadOnlyList<ResourceProviderEndpoint> globalNotificationEndpoints, ReRegisterSubscriptionMetadata reRegisterSubscriptionMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProviderAuthentication = providerAuthentication;
            ProviderAuthorizations = providerAuthorizations;
            Namespace = @namespace;
            ProviderVersion = providerVersion;
            ProviderType = providerType;
            RequiredFeatures = requiredFeatures;
            FeaturesRule = featuresRule;
            RequestHeaderOptions = requestHeaderOptions;
            ResourceTypes = resourceTypes;
            Management = management;
            Capabilities = capabilities;
            Metadata = metadata;
            GlobalNotificationEndpoints = globalNotificationEndpoints;
            ReRegisterSubscriptionMetadata = reRegisterSubscriptionMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provider authentication. </summary>
        internal ResourceProviderAuthentication ProviderAuthentication { get; }
        /// <summary> Gets the provider authentication allowed audiences. </summary>
        public IList<string> ProviderAuthenticationAllowedAudiences
        {
            get => ProviderAuthentication?.AllowedAudiences;
        }

        /// <summary> Gets the provider authorizations. </summary>
        public IReadOnlyList<ResourceProviderAuthorization> ProviderAuthorizations { get; }
        /// <summary> Gets the namespace. </summary>
        public string Namespace { get; }
        /// <summary> Gets the provider version. </summary>
        public string ProviderVersion { get; }
        /// <summary> Gets the provider type. </summary>
        public ResourceProviderType? ProviderType { get; }
        /// <summary> Gets the required features. </summary>
        public IReadOnlyList<string> RequiredFeatures { get; }
        /// <summary> Gets the features rule. </summary>
        internal FeaturesRule FeaturesRule { get; }
        /// <summary> Gets the required features policy. </summary>
        public FeaturesPolicy? RequiredFeaturesPolicy
        {
            get => FeaturesRule?.RequiredFeaturesPolicy;
        }

        /// <summary> Gets the request header options. </summary>
        internal RequestHeaderOptions RequestHeaderOptions { get; }
        /// <summary> Gets the opt in headers. </summary>
        public OptInHeaderType? OptInHeaders
        {
            get => RequestHeaderOptions?.OptInHeaders;
        }

        /// <summary> Gets the resource types. </summary>
        public IReadOnlyList<ProviderResourceType> ResourceTypes { get; }
        /// <summary> Gets the management. </summary>
        public ResourceProviderManagement Management { get; }
        /// <summary> Gets the capabilities. </summary>
        public IReadOnlyList<ResourceProviderCapabilities> Capabilities { get; }
        /// <summary>
        /// Anything
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Metadata { get; }
        /// <summary> Gets the global notification endpoints. </summary>
        public IReadOnlyList<ResourceProviderEndpoint> GlobalNotificationEndpoints { get; }
        /// <summary> Gets the re register subscription metadata. </summary>
        public ReRegisterSubscriptionMetadata ReRegisterSubscriptionMetadata { get; }
    }
}
