// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceProviderCapabilitiesEffect. </summary>
    public readonly partial struct ResourceProviderCapabilitiesEffect : IEquatable<ResourceProviderCapabilitiesEffect>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceProviderCapabilitiesEffect"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceProviderCapabilitiesEffect(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string AllowValue = "Allow";
        private const string DisallowValue = "Disallow";

        /// <summary> NotSpecified. </summary>
        public static ResourceProviderCapabilitiesEffect NotSpecified { get; } = new ResourceProviderCapabilitiesEffect(NotSpecifiedValue);
        /// <summary> Allow. </summary>
        public static ResourceProviderCapabilitiesEffect Allow { get; } = new ResourceProviderCapabilitiesEffect(AllowValue);
        /// <summary> Disallow. </summary>
        public static ResourceProviderCapabilitiesEffect Disallow { get; } = new ResourceProviderCapabilitiesEffect(DisallowValue);
        /// <summary> Determines if two <see cref="ResourceProviderCapabilitiesEffect"/> values are the same. </summary>
        public static bool operator ==(ResourceProviderCapabilitiesEffect left, ResourceProviderCapabilitiesEffect right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceProviderCapabilitiesEffect"/> values are not the same. </summary>
        public static bool operator !=(ResourceProviderCapabilitiesEffect left, ResourceProviderCapabilitiesEffect right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceProviderCapabilitiesEffect"/>. </summary>
        public static implicit operator ResourceProviderCapabilitiesEffect(string value) => new ResourceProviderCapabilitiesEffect(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceProviderCapabilitiesEffect other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceProviderCapabilitiesEffect other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
