// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceProviderAuthorization. </summary>
    public partial class ResourceProviderAuthorization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceProviderAuthorization"/>. </summary>
        public ResourceProviderAuthorization()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceProviderAuthorization"/>. </summary>
        /// <param name="applicationId"></param>
        /// <param name="roleDefinitionId"></param>
        /// <param name="managedByRoleDefinitionId"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceProviderAuthorization(string applicationId, string roleDefinitionId, string managedByRoleDefinitionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApplicationId = applicationId;
            RoleDefinitionId = roleDefinitionId;
            ManagedByRoleDefinitionId = managedByRoleDefinitionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the application id. </summary>
        public string ApplicationId { get; set; }
        /// <summary> Gets or sets the role definition id. </summary>
        public string RoleDefinitionId { get; set; }
        /// <summary> Gets or sets the managed by role definition id. </summary>
        public string ManagedByRoleDefinitionId { get; set; }
    }
}
