// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceProviderAuthentication. </summary>
    internal partial class ResourceProviderAuthentication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceProviderAuthentication"/>. </summary>
        /// <param name="allowedAudiences"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="allowedAudiences"/> is null. </exception>
        public ResourceProviderAuthentication(IEnumerable<string> allowedAudiences)
        {
            Argument.AssertNotNull(allowedAudiences, nameof(allowedAudiences));

            AllowedAudiences = allowedAudiences.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceProviderAuthentication"/>. </summary>
        /// <param name="allowedAudiences"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceProviderAuthentication(IList<string> allowedAudiences, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AllowedAudiences = allowedAudiences;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceProviderAuthentication"/> for deserialization. </summary>
        internal ResourceProviderAuthentication()
        {
        }

        /// <summary> Gets the allowed audiences. </summary>
        public IList<string> AllowedAudiences { get; }
    }
}
