// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub.Models
{
    public partial class ResourceMovePolicy : IUtf8JsonSerializable, IJsonModel<ResourceMovePolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResourceMovePolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResourceMovePolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceMovePolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceMovePolicy)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsValidationRequired))
            {
                writer.WritePropertyName("validationRequired"u8);
                writer.WriteBooleanValue(IsValidationRequired.Value);
            }
            if (Optional.IsDefined(IsCrossResourceGroupMoveEnabled))
            {
                writer.WritePropertyName("crossResourceGroupMoveEnabled"u8);
                writer.WriteBooleanValue(IsCrossResourceGroupMoveEnabled.Value);
            }
            if (Optional.IsDefined(IsCrossSubscriptionMoveEnabled))
            {
                writer.WritePropertyName("crossSubscriptionMoveEnabled"u8);
                writer.WriteBooleanValue(IsCrossSubscriptionMoveEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResourceMovePolicy IJsonModel<ResourceMovePolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceMovePolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResourceMovePolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResourceMovePolicy(document.RootElement, options);
        }

        internal static ResourceMovePolicy DeserializeResourceMovePolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? validationRequired = default;
            bool? crossResourceGroupMoveEnabled = default;
            bool? crossSubscriptionMoveEnabled = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("validationRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    validationRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("crossResourceGroupMoveEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    crossResourceGroupMoveEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("crossSubscriptionMoveEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    crossSubscriptionMoveEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResourceMovePolicy(validationRequired, crossResourceGroupMoveEnabled, crossSubscriptionMoveEnabled, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResourceMovePolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceMovePolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResourceMovePolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ResourceMovePolicy IPersistableModel<ResourceMovePolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResourceMovePolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResourceMovePolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResourceMovePolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResourceMovePolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
