// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ResourceDeletionPolicy. </summary>
    public readonly partial struct ResourceDeletionPolicy : IEquatable<ResourceDeletionPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceDeletionPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceDeletionPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string CascadeDeleteAllValue = "CascadeDeleteAll";
        private const string CascadeDeleteProxyOnlyChildrenValue = "CascadeDeleteProxyOnlyChildren";

        /// <summary> NotSpecified. </summary>
        public static ResourceDeletionPolicy NotSpecified { get; } = new ResourceDeletionPolicy(NotSpecifiedValue);
        /// <summary> CascadeDeleteAll. </summary>
        public static ResourceDeletionPolicy CascadeDeleteAll { get; } = new ResourceDeletionPolicy(CascadeDeleteAllValue);
        /// <summary> CascadeDeleteProxyOnlyChildren. </summary>
        public static ResourceDeletionPolicy CascadeDeleteProxyOnlyChildren { get; } = new ResourceDeletionPolicy(CascadeDeleteProxyOnlyChildrenValue);
        /// <summary> Determines if two <see cref="ResourceDeletionPolicy"/> values are the same. </summary>
        public static bool operator ==(ResourceDeletionPolicy left, ResourceDeletionPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceDeletionPolicy"/> values are not the same. </summary>
        public static bool operator !=(ResourceDeletionPolicy left, ResourceDeletionPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceDeletionPolicy"/>. </summary>
        public static implicit operator ResourceDeletionPolicy(string value) => new ResourceDeletionPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceDeletionPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceDeletionPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
