// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ProviderHub.Models
{
    internal static partial class ResourceAccessPolicyExtensions
    {
        public static string ToSerialString(this ResourceAccessPolicy value) => value switch
        {
            ResourceAccessPolicy.NotSpecified => "NotSpecified",
            ResourceAccessPolicy.AcisReadAllowed => "AcisReadAllowed",
            ResourceAccessPolicy.AcisActionAllowed => "AcisActionAllowed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResourceAccessPolicy value.")
        };

        public static ResourceAccessPolicy ToResourceAccessPolicy(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSpecified")) return ResourceAccessPolicy.NotSpecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AcisReadAllowed")) return ResourceAccessPolicy.AcisReadAllowed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AcisActionAllowed")) return ResourceAccessPolicy.AcisActionAllowed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResourceAccessPolicy value.");
        }
    }
}
