// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ProviderSubscriptionState. </summary>
    public readonly partial struct ProviderSubscriptionState : IEquatable<ProviderSubscriptionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProviderSubscriptionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProviderSubscriptionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotDefinedValue = "NotDefined";
        private const string EnabledValue = "Enabled";
        private const string WarnedValue = "Warned";
        private const string PastDueValue = "PastDue";
        private const string DisabledValue = "Disabled";
        private const string DeletedValue = "Deleted";

        /// <summary> NotDefined. </summary>
        public static ProviderSubscriptionState NotDefined { get; } = new ProviderSubscriptionState(NotDefinedValue);
        /// <summary> Enabled. </summary>
        public static ProviderSubscriptionState Enabled { get; } = new ProviderSubscriptionState(EnabledValue);
        /// <summary> Warned. </summary>
        public static ProviderSubscriptionState Warned { get; } = new ProviderSubscriptionState(WarnedValue);
        /// <summary> PastDue. </summary>
        public static ProviderSubscriptionState PastDue { get; } = new ProviderSubscriptionState(PastDueValue);
        /// <summary> Disabled. </summary>
        public static ProviderSubscriptionState Disabled { get; } = new ProviderSubscriptionState(DisabledValue);
        /// <summary> Deleted. </summary>
        public static ProviderSubscriptionState Deleted { get; } = new ProviderSubscriptionState(DeletedValue);
        /// <summary> Determines if two <see cref="ProviderSubscriptionState"/> values are the same. </summary>
        public static bool operator ==(ProviderSubscriptionState left, ProviderSubscriptionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProviderSubscriptionState"/> values are not the same. </summary>
        public static bool operator !=(ProviderSubscriptionState left, ProviderSubscriptionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProviderSubscriptionState"/>. </summary>
        public static implicit operator ProviderSubscriptionState(string value) => new ProviderSubscriptionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProviderSubscriptionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProviderSubscriptionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
