// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ProviderHubProvisioningState. </summary>
    public readonly partial struct ProviderHubProvisioningState : IEquatable<ProviderHubProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProviderHubProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProviderHubProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string AcceptedValue = "Accepted";
        private const string RunningValue = "Running";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string MovingResourcesValue = "MovingResources";
        private const string TransientFailureValue = "TransientFailure";
        private const string RolloutInProgressValue = "RolloutInProgress";

        /// <summary> NotSpecified. </summary>
        public static ProviderHubProvisioningState NotSpecified { get; } = new ProviderHubProvisioningState(NotSpecifiedValue);
        /// <summary> Accepted. </summary>
        public static ProviderHubProvisioningState Accepted { get; } = new ProviderHubProvisioningState(AcceptedValue);
        /// <summary> Running. </summary>
        public static ProviderHubProvisioningState Running { get; } = new ProviderHubProvisioningState(RunningValue);
        /// <summary> Creating. </summary>
        public static ProviderHubProvisioningState Creating { get; } = new ProviderHubProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static ProviderHubProvisioningState Created { get; } = new ProviderHubProvisioningState(CreatedValue);
        /// <summary> Deleting. </summary>
        public static ProviderHubProvisioningState Deleting { get; } = new ProviderHubProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static ProviderHubProvisioningState Deleted { get; } = new ProviderHubProvisioningState(DeletedValue);
        /// <summary> Canceled. </summary>
        public static ProviderHubProvisioningState Canceled { get; } = new ProviderHubProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static ProviderHubProvisioningState Failed { get; } = new ProviderHubProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static ProviderHubProvisioningState Succeeded { get; } = new ProviderHubProvisioningState(SucceededValue);
        /// <summary> MovingResources. </summary>
        public static ProviderHubProvisioningState MovingResources { get; } = new ProviderHubProvisioningState(MovingResourcesValue);
        /// <summary> TransientFailure. </summary>
        public static ProviderHubProvisioningState TransientFailure { get; } = new ProviderHubProvisioningState(TransientFailureValue);
        /// <summary> RolloutInProgress. </summary>
        public static ProviderHubProvisioningState RolloutInProgress { get; } = new ProviderHubProvisioningState(RolloutInProgressValue);
        /// <summary> Determines if two <see cref="ProviderHubProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ProviderHubProvisioningState left, ProviderHubProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProviderHubProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ProviderHubProvisioningState left, ProviderHubProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProviderHubProvisioningState"/>. </summary>
        public static implicit operator ProviderHubProvisioningState(string value) => new ProviderHubProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProviderHubProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProviderHubProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
