// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ProviderHubMetadata. </summary>
    public partial class ProviderHubMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProviderHubMetadata"/>. </summary>
        public ProviderHubMetadata()
        {
            ProviderAuthorizations = new ChangeTrackingList<ResourceProviderAuthorization>();
        }

        /// <summary> Initializes a new instance of <see cref="ProviderHubMetadata"/>. </summary>
        /// <param name="providerAuthorizations"></param>
        /// <param name="providerAuthentication"></param>
        /// <param name="thirdPartyProviderAuthorization"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProviderHubMetadata(IList<ResourceProviderAuthorization> providerAuthorizations, ResourceProviderAuthentication providerAuthentication, ThirdPartyProviderAuthorization thirdPartyProviderAuthorization, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProviderAuthorizations = providerAuthorizations;
            ProviderAuthentication = providerAuthentication;
            ThirdPartyProviderAuthorization = thirdPartyProviderAuthorization;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provider authorizations. </summary>
        public IList<ResourceProviderAuthorization> ProviderAuthorizations { get; }
        /// <summary> Gets or sets the provider authentication. </summary>
        internal ResourceProviderAuthentication ProviderAuthentication { get; set; }
        /// <summary> Gets or sets the provider authentication allowed audiences. </summary>
        public IList<string> ProviderAuthenticationAllowedAudiences
        {
            get => ProviderAuthentication is null ? default : ProviderAuthentication.AllowedAudiences;
            set => ProviderAuthentication = new ResourceProviderAuthentication(value);
        }

        /// <summary> Gets or sets the third party provider authorization. </summary>
        public ThirdPartyProviderAuthorization ThirdPartyProviderAuthorization { get; set; }
    }
}
