// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub.Models
{
    public partial class ProviderHubExtendedLocationOptions : IUtf8JsonSerializable, IJsonModel<ProviderHubExtendedLocationOptions>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ProviderHubExtendedLocationOptions>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ProviderHubExtendedLocationOptions>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderHubExtendedLocationOptions>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProviderHubExtendedLocationOptions)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ExtendedLocationOptionsType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(ExtendedLocationOptionsType);
            }
            if (Optional.IsDefined(SupportedPolicy))
            {
                writer.WritePropertyName("supportedPolicy"u8);
                writer.WriteStringValue(SupportedPolicy);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ProviderHubExtendedLocationOptions IJsonModel<ProviderHubExtendedLocationOptions>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderHubExtendedLocationOptions>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProviderHubExtendedLocationOptions)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeProviderHubExtendedLocationOptions(document.RootElement, options);
        }

        internal static ProviderHubExtendedLocationOptions DeserializeProviderHubExtendedLocationOptions(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            string supportedPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("supportedPolicy"u8))
                {
                    supportedPolicy = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ProviderHubExtendedLocationOptions(type, supportedPolicy, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ProviderHubExtendedLocationOptions>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderHubExtendedLocationOptions>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ProviderHubExtendedLocationOptions)} does not support writing '{options.Format}' format.");
            }
        }

        ProviderHubExtendedLocationOptions IPersistableModel<ProviderHubExtendedLocationOptions>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderHubExtendedLocationOptions>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeProviderHubExtendedLocationOptions(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ProviderHubExtendedLocationOptions)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ProviderHubExtendedLocationOptions>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
