// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The PreflightOption. </summary>
    public readonly partial struct PreflightOption : IEquatable<PreflightOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PreflightOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PreflightOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ContinueDeploymentOnFailureValue = "ContinueDeploymentOnFailure";
        private const string DefaultValidationOnlyValue = "DefaultValidationOnly";

        /// <summary> None. </summary>
        public static PreflightOption None { get; } = new PreflightOption(NoneValue);
        /// <summary> ContinueDeploymentOnFailure. </summary>
        public static PreflightOption ContinueDeploymentOnFailure { get; } = new PreflightOption(ContinueDeploymentOnFailureValue);
        /// <summary> DefaultValidationOnly. </summary>
        public static PreflightOption DefaultValidationOnly { get; } = new PreflightOption(DefaultValidationOnlyValue);
        /// <summary> Determines if two <see cref="PreflightOption"/> values are the same. </summary>
        public static bool operator ==(PreflightOption left, PreflightOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PreflightOption"/> values are not the same. </summary>
        public static bool operator !=(PreflightOption left, PreflightOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PreflightOption"/>. </summary>
        public static implicit operator PreflightOption(string value) => new PreflightOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PreflightOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PreflightOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
