// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The MessageScope. </summary>
    public readonly partial struct MessageScope : IEquatable<MessageScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string RegisteredSubscriptionsValue = "RegisteredSubscriptions";

        /// <summary> NotSpecified. </summary>
        public static MessageScope NotSpecified { get; } = new MessageScope(NotSpecifiedValue);
        /// <summary> RegisteredSubscriptions. </summary>
        public static MessageScope RegisteredSubscriptions { get; } = new MessageScope(RegisteredSubscriptionsValue);
        /// <summary> Determines if two <see cref="MessageScope"/> values are the same. </summary>
        public static bool operator ==(MessageScope left, MessageScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageScope"/> values are not the same. </summary>
        public static bool operator !=(MessageScope left, MessageScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageScope"/>. </summary>
        public static implicit operator MessageScope(string value) => new MessageScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
