// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ManifestResourceDeletionPolicy. </summary>
    public readonly partial struct ManifestResourceDeletionPolicy : IEquatable<ManifestResourceDeletionPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManifestResourceDeletionPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManifestResourceDeletionPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string CascadeValue = "Cascade";
        private const string ForceValue = "Force";

        /// <summary> NotSpecified. </summary>
        public static ManifestResourceDeletionPolicy NotSpecified { get; } = new ManifestResourceDeletionPolicy(NotSpecifiedValue);
        /// <summary> Cascade. </summary>
        public static ManifestResourceDeletionPolicy Cascade { get; } = new ManifestResourceDeletionPolicy(CascadeValue);
        /// <summary> Force. </summary>
        public static ManifestResourceDeletionPolicy Force { get; } = new ManifestResourceDeletionPolicy(ForceValue);
        /// <summary> Determines if two <see cref="ManifestResourceDeletionPolicy"/> values are the same. </summary>
        public static bool operator ==(ManifestResourceDeletionPolicy left, ManifestResourceDeletionPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManifestResourceDeletionPolicy"/> values are not the same. </summary>
        public static bool operator !=(ManifestResourceDeletionPolicy left, ManifestResourceDeletionPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManifestResourceDeletionPolicy"/>. </summary>
        public static implicit operator ManifestResourceDeletionPolicy(string value) => new ManifestResourceDeletionPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManifestResourceDeletionPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManifestResourceDeletionPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
