// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The LoggingDetail. </summary>
    public readonly partial struct LoggingDetail : IEquatable<LoggingDetail>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LoggingDetail"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LoggingDetail(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string BodyValue = "Body";

        /// <summary> None. </summary>
        public static LoggingDetail None { get; } = new LoggingDetail(NoneValue);
        /// <summary> Body. </summary>
        public static LoggingDetail Body { get; } = new LoggingDetail(BodyValue);
        /// <summary> Determines if two <see cref="LoggingDetail"/> values are the same. </summary>
        public static bool operator ==(LoggingDetail left, LoggingDetail right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LoggingDetail"/> values are not the same. </summary>
        public static bool operator !=(LoggingDetail left, LoggingDetail right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LoggingDetail"/>. </summary>
        public static implicit operator LoggingDetail(string value) => new LoggingDetail(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LoggingDetail other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LoggingDetail other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
